set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9647114';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-5-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3444',
      '20441043',
      NULL,
      83.423084,
      '3401303',
      30.438051,
      1,
      1.291060,
      NULL,
      '220224',
      3.322381,
      ' 2-10-1987',
      23,
      51.578737,
      1,
      NULL,
      1,
      NULL,
      2.472251,
      0,
      1.111572,
      1,
      1.146215,
      0.227824,
      0.511509,
      0.013886,
      4.118098,
      0,
      1,
      8,
      0.044861,
      0.378617,
      NULL,
      7,
      NULL,
      3.830558,
      NULL,
      1,
      1.876394,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      11.147222,
      1.427635,
      3.803431,
      2,
      1.874573,
      0.064241,
      3,
      NULL,
      0,
      2.887757,
      2.278999,
      0,
      2,
      2.754161,
      0.993546,
      1,
      1,
      1.497281,
      NULL,
      NULL,
      2,
      0,
      5.284994,
      NULL,
      2,
      3.813497,
      1.579448,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5,
      3.349730,
      0,
      0,
      NULL,
      1,
      1.764425,
      0.814515,
      0,
      0.394609,
      1,
      0.895067,
      1.851608,
      NULL,
      0.789101,
      NULL,
      0.135783,
      0.190565,
      NULL,
      1.730208,
      1,
      0,
      1,
      1.574546,
      1,
      1.464631,
      1.906594,
      NULL,
      0,
      1.246508,
      1.573598,
      0.570844,
      0,
      2,
      1.467052,
      1.742257,
      9,
      7,
      NULL,
      7,
      7.429114,
      2,
      1.120404,
      2.114137,
      0,
      5.385099,
      2.515606,
      3.184437,
      1,
      1.283077,
      2,
      0.377505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1.807969,
      1,
      0.794191,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.778375,
      3.617483,
      0.455507,
      0.039073,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.226046,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.595098,
      NULL,
      2,
      1.679165,
      3,
      0,
      5.920129,
      1.488464,
      NULL,
      NULL,
      0.437030,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.881631,
      3,
      3.896609,
      0,
      2,
      1,
      NULL,
      NULL,
      1.063691,
      2,
      1.936236,
      0.904522,
      1.306760,
      1.065303,
      NULL,
      1.162507,
      1.265261,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.326285,
      0.218566,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.544308,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.563738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.188825,
      0,
      NULL,
      1.049349,
      1.290420,
      1,
      2,
      0.532131,
      '24103',
      '',
      '',
      0,
      '',
      '',
      '',
      3,
      NULL,
      '',
      '',
      3,
      NULL,
      0,
      0.411080,
      2,
      1.275092,
      NULL,
      2.875634,
      1);
commit;
end;
/


