set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8505820';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-1-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '133',
      '01102041',
      48.588310,
      18.145662,
      NULL,
      19,
      2,
      3.223305,
      1,
      NULL,
      1,
      NULL,
      33,
      39,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      2,
      NULL,
      0.378124,
      0.683885,
      1.050272,
      1.094539,
      0.784097,
      1.395231,
      0,
      1,
      1,
      7,
      0,
      0.998802,
      1,
      1,
      0,
      2,
      0,
      3.749792,
      1,
      0.988745,
      1.636381,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.671860,
      NULL,
      NULL,
      NULL,
      NULL,
      1.756578,
      0,
      3.062343,
      NULL,
      0.020589,
      0,
      0,
      2,
      2,
      1.504488,
      3.606999,
      0,
      0.172774,
      0.909164,
      NULL,
      1,
      5,
      1,
      2,
      1.888571,
      1.055510,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.867056,
      1,
      0,
      1,
      1.569350,
      NULL,
      1.306610,
      0,
      1,
      1.528710,
      NULL,
      0,
      NULL,
      0.271048,
      0.250823,
      1,
      NULL,
      1.894475,
      0.944505,
      NULL,
      0.363435,
      0,
      1.964091,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.324229,
      NULL,
      0.994966,
      2.698034,
      0,
      1.260621,
      0.095277,
      1,
      3.469815,
      4.864683,
      NULL,
      1,
      NULL,
      4.640173,
      3,
      1,
      1.847230,
      2.232446,
      1,
      1.067499,
      1.063848,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.375666,
      1.456929,
      2,
      1,
      NULL,
      2,
      1.105688,
      0.774332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.136555,
      NULL,
      NULL,
      NULL,
      NULL,
      0.853038,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      3,
      1.711921,
      NULL,
      1,
      NULL,
      2.861168,
      0.730613,
      3.912324,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.797090,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1.495727,
      0,
      1.355700,
      1.029510,
      1,
      0.789271,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      1.003065,
      1,
      NULL,
      1.413849,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.149445,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '23221',
      '',
      NULL,
      0.799767,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      3.660806,
      2,
      6.148509,
      0,
      NULL,
      3,
      0,
      1.340951);
commit;
end;
/


