set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8505820';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-3-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '223',
      NULL,
      21,
      23.891746,
      '3140433',
      33.796983,
      4,
      3.524062,
      NULL,
      '400211',
      1,
      '11- 7-1997',
      15.502312,
      NULL,
      0.894796,
      NULL,
      1.694719,
      3.669965,
      1.909006,
      NULL,
      1.895569,
      0.775045,
      0,
      NULL,
      1.507643,
      1,
      2,
      0.380242,
      0.123918,
      2.746501,
      1.778914,
      1,
      6.433184,
      1,
      0.269478,
      1,
      2.233121,
      NULL,
      NULL,
      1,
      NULL,
      1.144785,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.160558,
      0.463373,
      1,
      0.507663,
      0.709023,
      1,
      3.038937,
      0.645812,
      2,
      2,
      0,
      0,
      NULL,
      NULL,
      2,
      0,
      0.843407,
      0,
      7.354683,
      3,
      0.463749,
      11.332489,
      0,
      1,
      NULL,
      0.082528,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.789066,
      1,
      0,
      1.354076,
      1,
      0.873387,
      0.902007,
      0.523881,
      0,
      NULL,
      1.833930,
      NULL,
      0.919611,
      0.595908,
      0.783092,
      1.143765,
      NULL,
      1,
      0,
      0.709806,
      NULL,
      0.169557,
      1.393634,
      1,
      1,
      5,
      1,
      0,
      NULL,
      1,
      NULL,
      2.505013,
      NULL,
      0,
      0,
      1,
      NULL,
      5.867661,
      4.286838,
      2.536713,
      NULL,
      6.207664,
      1.919582,
      0.756983,
      1,
      1.548454,
      0.820459,
      0.870181,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.622558,
      NULL,
      NULL,
      NULL,
      NULL,
      0.160838,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.125379,
      2,
      1.074287,
      NULL,
      NULL,
      NULL,
      1,
      1.597937,
      1.214186,
      1,
      0.680736,
      0,
      4,
      1.011505,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3,
      NULL,
      0,
      2.863710,
      NULL,
      NULL,
      0,
      2.763822,
      1.819576,
      1,
      1,
      0.386022,
      0,
      1.931354,
      1,
      1.229667,
      1,
      1.055988,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.570718,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '10103',
      '',
      '',
      0,
      '',
      NULL,
      NULL,
      1,
      '',
      NULL,
      '',
      1,
      NULL,
      0,
      3.727610,
      3.383172,
      5,
      1,
      2,
      NULL);
commit;
end;
/


