set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8505820';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-6-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '242',
      '02001231',
      42.712689,
      57.226719,
      '4432321',
      1.427026,
      NULL,
      0.114513,
      1,
      '032400',
      NULL,
      ' 1-22-2003',
      44,
      NULL,
      1,
      NULL,
      NULL,
      0.797017,
      1,
      1,
      1,
      1,
      3.244644,
      1,
      0,
      1,
      3.313417,
      NULL,
      1,
      1,
      0.199991,
      6.841461,
      NULL,
      1.486778,
      1.238497,
      0.888107,
      NULL,
      1,
      5.090720,
      0,
      5.090202,
      0,
      1.868524,
      1.605333,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      1.209288,
      0,
      0.401790,
      1,
      0,
      NULL,
      1.021487,
      3.792020,
      3,
      0.236914,
      0.857468,
      1.219454,
      0,
      3,
      NULL,
      0,
      0,
      11,
      NULL,
      0.929537,
      4.283753,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.432422,
      NULL,
      1.427511,
      1.451975,
      1,
      1.814434,
      0.875791,
      0,
      0,
      1,
      NULL,
      0.571151,
      1,
      1.657896,
      1,
      0.977946,
      NULL,
      1.771102,
      NULL,
      NULL,
      NULL,
      2.589817,
      NULL,
      1,
      0.461131,
      0,
      1,
      NULL,
      NULL,
      4.901450,
      7.452485,
      0.005650,
      0.543382,
      0.621347,
      3,
      1.356836,
      0.476777,
      NULL,
      3.489142,
      7.221911,
      5.175910,
      1.386058,
      NULL,
      3,
      1,
      1.039032,
      0,
      1.257907,
      3.040566,
      0,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      1.004590,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.556263,
      NULL,
      NULL,
      NULL,
      NULL,
      0.373949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.177734,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.490298,
      1.398567,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.575159,
      0.262016,
      NULL,
      NULL,
      NULL,
      2,
      0.327139,
      NULL,
      3.034709,
      1,
      0.417628,
      0.058041,
      0,
      1.615252,
      0.261290,
      0,
      0.944157,
      NULL,
      1.762475,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      '42110',
      '',
      '',
      0.709904,
      '',
      '',
      '',
      0.356918,
      '',
      '',
      NULL,
      1.060707,
      5.177159,
      1.370479,
      5,
      0,
      2.912566,
      0.224714,
      2.724379,
      NULL);
commit;
end;
/


