set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8505820';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-2-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '212',
      NULL,
      60.322177,
      35,
      NULL,
      2,
      6,
      2,
      NULL,
      '031141',
      NULL,
      '11- 5-1974',
      NULL,
      NULL,
      0.578321,
      NULL,
      1.429259,
      0.823865,
      1,
      0,
      1.383842,
      1.999159,
      2,
      0,
      1.169806,
      1.451516,
      NULL,
      NULL,
      3,
      1,
      1.204552,
      0.061299,
      NULL,
      NULL,
      NULL,
      0,
      0.805516,
      0,
      6,
      NULL,
      1.406680,
      0,
      3,
      0.230918,
      NULL,
      NULL,
      0.557156,
      NULL,
      NULL,
      9,
      1,
      6,
      1,
      0,
      0.030806,
      3.930425,
      1,
      0,
      1,
      NULL,
      1.984297,
      3.724087,
      3,
      1,
      2,
      0,
      1.988730,
      NULL,
      3.209539,
      1.896568,
      1,
      7.040717,
      1,
      NULL,
      NULL,
      0.293248,
      NULL,
      NULL,
      1.362512,
      NULL,
      NULL,
      0.735894,
      1.934988,
      1,
      1,
      1.638334,
      NULL,
      1,
      0.440365,
      1.283888,
      1.482427,
      NULL,
      1,
      1.206508,
      0.171990,
      0,
      1,
      1.904693,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.197466,
      0,
      1.950940,
      0.808087,
      1,
      0.473277,
      NULL,
      NULL,
      NULL,
      NULL,
      1.298619,
      1.948371,
      1,
      NULL,
      0.251062,
      2.068779,
      2.561827,
      3,
      0,
      1,
      1,
      0,
      0.901406,
      1.333169,
      1.443360,
      0,
      2,
      NULL,
      1.680782,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.951112,
      1,
      0,
      1,
      0,
      1.020371,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.888364,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.055995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.390780,
      1,
      NULL,
      0.381243,
      1.086483,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.951371,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.138154,
      NULL,
      NULL,
      NULL,
      3.905283,
      0.675474,
      0,
      NULL,
      1,
      0,
      1,
      0,
      1.865132,
      1.032345,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '10021',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      5.594033,
      1.352289,
      2,
      2.064704,
      0,
      3.298336,
      0,
      NULL,
      NULL);
commit;
end;
/


