set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8505820';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-7-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '42400023',
      29,
      25.757502,
      '0430244',
      63.575008,
      NULL,
      3.033745,
      0,
      '042333',
      3,
      NULL,
      53,
      45.605180,
      1.143292,
      NULL,
      NULL,
      0.703724,
      3,
      1,
      0.459749,
      1,
      0,
      0,
      1,
      NULL,
      1.515944,
      NULL,
      0,
      0,
      1,
      NULL,
      2,
      3,
      2,
      0.566943,
      0,
      0.596229,
      NULL,
      1,
      0,
      0,
      0.731033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      5,
      2.070148,
      NULL,
      0,
      0.490542,
      3,
      1,
      NULL,
      NULL,
      1.524140,
      NULL,
      0.011237,
      0,
      NULL,
      1.848337,
      1,
      NULL,
      2,
      0.111237,
      NULL,
      1.668885,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      1.579958,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      0,
      1,
      0.143083,
      0,
      1.266681,
      1.034314,
      1.515269,
      1.430014,
      NULL,
      1.684853,
      0.189388,
      0.274164,
      0.834743,
      0,
      0.112039,
      NULL,
      NULL,
      0,
      0.940160,
      1,
      1,
      0.941584,
      0,
      0.872157,
      NULL,
      NULL,
      NULL,
      NULL,
      2.079465,
      1.880349,
      3.541006,
      1,
      0,
      2,
      1,
      3.294494,
      0.638850,
      1,
      NULL,
      1.111421,
      4,
      1.757814,
      1.030211,
      0.508901,
      1,
      1.654058,
      NULL,
      0,
      0.920241,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.911624,
      0,
      1,
      1,
      1.528896,
      0.821033,
      0.026922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.168888,
      2.427225,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.975094,
      1.433898,
      4,
      0.054004,
      0,
      1.724662,
      NULL,
      NULL,
      NULL,
      1,
      0.544501,
      0.633972,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.060459,
      2.924090,
      NULL,
      NULL,
      1.985038,
      1,
      0,
      1,
      2.539724,
      1.103518,
      1,
      0.177351,
      0.054070,
      0,
      1.636072,
      0,
      1.120112,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.660558,
      NULL,
      '',
      '',
      0.924690,
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      2.185171,
      0.266711,
      1,
      3.801329,
      2,
      NULL,
      NULL,
      2,
      0.397989);
commit;
end;
/


