set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8505820';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-1-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '02330114',
      4,
      NULL,
      '0304442',
      82.124836,
      5,
      0.351210,
      NULL,
      '040113',
      5,
      ' 9-11-1997',
      51.836707,
      43,
      0,
      NULL,
      0,
      1.251888,
      1,
      0.207948,
      NULL,
      0,
      NULL,
      1.745370,
      1,
      1,
      NULL,
      0,
      0.828039,
      3.604924,
      1.980457,
      0,
      1,
      3.944025,
      5.730448,
      2,
      3.813001,
      NULL,
      NULL,
      0,
      2,
      0.318602,
      0.322357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4.496550,
      NULL,
      NULL,
      0,
      NULL,
      2.821554,
      0,
      NULL,
      2,
      NULL,
      3,
      NULL,
      1.767565,
      1.537124,
      0.935402,
      1,
      0.153965,
      5,
      2.194302,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.173371,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.055471,
      NULL,
      1.831055,
      0,
      NULL,
      NULL,
      0,
      1.440246,
      0,
      NULL,
      1.595185,
      1,
      1.344365,
      1,
      1,
      0,
      0.758776,
      0,
      NULL,
      1,
      0,
      1.339169,
      0.012487,
      1,
      NULL,
      1,
      1.495824,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      4.075611,
      1.496619,
      1.040261,
      1,
      0,
      1,
      0.452481,
      1.446788,
      0,
      2,
      5.271806,
      0.843975,
      1,
      0,
      NULL,
      0.428610,
      0.547938,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.690209,
      1,
      1,
      1,
      1,
      0,
      1.947188,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.431339,
      1.291380,
      3.673775,
      1.433302,
      1.399978,
      0,
      2.152495,
      2.906889,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.966742,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.325556,
      0,
      NULL,
      1.237063,
      1,
      0.903441,
      0.757953,
      1,
      0.091184,
      NULL,
      1.541423,
      0,
      1.452104,
      0.606735,
      0.766116,
      1,
      1.958218,
      1,
      0,
      0.991498,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '40430',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      1.999371,
      3.264125,
      1.376734,
      3.651490,
      3,
      0,
      1,
      0.917258,
      1);
commit;
end;
/


