set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902224';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-4-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '3',
      NULL,
      NULL,
      NULL,
      26.526162,
      NULL,
      NULL,
      1,
      NULL,
      1,
      ' 2-12-2000',
      32.120889,
      NULL,
      0,
      NULL,
      1,
      0.073456,
      1,
      1,
      1.107621,
      0,
      1,
      1.054884,
      0.922008,
      0,
      6.023635,
      0.285873,
      1.833970,
      0.424749,
      1,
      1,
      1,
      0.816030,
      NULL,
      0,
      1,
      NULL,
      1.472395,
      1,
      3.028065,
      0,
      1,
      0,
      NULL,
      NULL,
      0.808325,
      NULL,
      NULL,
      1,
      0.723872,
      NULL,
      0.600067,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.493674,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.747567,
      NULL,
      1,
      0,
      4.796622,
      4,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0,
      4,
      0.886139,
      NULL,
      1,
      0,
      1.163019,
      NULL,
      0.201706,
      1.302649,
      NULL,
      0,
      0,
      NULL,
      5.782388,
      0.537057,
      3,
      0,
      1,
      1.678473,
      1.853485,
      0.199109,
      3,
      2.790704,
      0,
      3.821580,
      0.226229,
      6,
      1.159897,
      6,
      0.591559,
      NULL,
      6,
      1,
      14.908315,
      5.686369,
      2,
      1.372127,
      1.246088,
      1.127408,
      1.673899,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6.177393,
      1,
      1,
      NULL,
      2.840082,
      0.106316,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.164611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.810578,
      1.002475,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.948963,
      5.361872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.777182,
      1,
      3,
      NULL,
      0.776846,
      1,
      0.573885,
      NULL,
      1.287715,
      2.407033,
      0,
      NULL,
      0.727109,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.595119,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '02014',
      '',
      '',
      1.518189,
      '',
      '',
      NULL,
      1.919142,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


