set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902224';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-5-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '0',
      NULL,
      NULL,
      '4130031',
      116.881270,
      NULL,
      0.904329,
      NULL,
      '324304',
      NULL,
      '10- 5-1991',
      24,
      NULL,
      1,
      NULL,
      1.664556,
      NULL,
      0.445004,
      0.957531,
      0,
      1.179832,
      1,
      0.496690,
      2.578661,
      1,
      6,
      0.522519,
      NULL,
      2,
      2.397620,
      NULL,
      7.438154,
      NULL,
      NULL,
      1,
      NULL,
      0,
      4,
      1,
      1,
      1.242691,
      3.174782,
      1,
      NULL,
      NULL,
      1.603894,
      NULL,
      NULL,
      9,
      NULL,
      0,
      1.697455,
      NULL,
      NULL,
      3.893233,
      NULL,
      0,
      0.100390,
      3,
      0.175721,
      NULL,
      1.829036,
      0,
      1,
      0,
      NULL,
      1,
      0,
      0,
      6,
      6.581314,
      2,
      0,
      3,
      0.206861,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.138056,
      2,
      4,
      NULL,
      1,
      0.500625,
      NULL,
      0,
      1.782404,
      1.694479,
      1,
      0,
      0,
      0,
      0,
      NULL,
      1.468936,
      0.364355,
      NULL,
      NULL,
      0.101125,
      7.231862,
      5.808653,
      4.946479,
      2,
      NULL,
      0,
      1.916567,
      3,
      0.348292,
      NULL,
      NULL,
      4.370226,
      1,
      4.569571,
      0,
      2.374802,
      4.890792,
      2.291377,
      8,
      NULL,
      5,
      6.747507,
      NULL,
      NULL,
      1,
      3.168886,
      4,
      2.533191,
      NULL,
      0.194896,
      6.305109,
      1.600826,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.483519,
      1,
      0,
      1,
      0,
      4.300104,
      1.676956,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.046670,
      NULL,
      NULL,
      NULL,
      NULL,
      1.420493,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.615061,
      1.022902,
      0.022669,
      NULL,
      NULL,
      NULL,
      NULL,
      0.135955,
      0,
      0,
      1.908369,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.539747,
      3.585780,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      1.120738,
      NULL,
      NULL,
      3,
      1,
      1,
      0.200300,
      1,
      1.066401,
      0,
      NULL,
      0,
      0,
      1,
      1.446430,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.001444,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.445362,
      '02443',
      '',
      '',
      1.545254,
      '44311',
      '',
      '',
      0,
      '1022',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


