set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902224';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-9-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      NULL,
      NULL,
      '3221401',
      26,
      3,
      3,
      NULL,
      '244302',
      NULL,
      ' 5- 3-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      3.459338,
      1.479786,
      NULL,
      1.267718,
      NULL,
      2.812213,
      0.123090,
      1.922256,
      2,
      NULL,
      2,
      NULL,
      0,
      7.505482,
      8,
      0,
      NULL,
      1.131366,
      0.600276,
      1,
      1,
      1,
      8,
      1,
      4.703364,
      3.304826,
      NULL,
      0,
      NULL,
      NULL,
      1.886467,
      NULL,
      NULL,
      NULL,
      0.465310,
      1.548382,
      0,
      NULL,
      1.259117,
      1,
      1.093511,
      2.858080,
      1.481801,
      NULL,
      1.440991,
      3,
      0.772810,
      1,
      0,
      1,
      NULL,
      1,
      1,
      0.040413,
      1,
      6,
      NULL,
      0,
      1.625717,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      4,
      1,
      1.941358,
      1.707883,
      3,
      0.482917,
      1.900190,
      5,
      1,
      3.539250,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      0.589908,
      NULL,
      1,
      5.326423,
      1,
      NULL,
      1.805275,
      3,
      1,
      0,
      5,
      1.474712,
      NULL,
      1.783866,
      1.270467,
      0,
      7,
      3.296177,
      NULL,
      NULL,
      1,
      1,
      1,
      6,
      6,
      5.861306,
      5,
      2,
      0.230734,
      0,
      1.997278,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.385459,
      4,
      1,
      1,
      0.104562,
      2.938761,
      1,
      1.144985,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.822002,
      NULL,
      NULL,
      NULL,
      NULL,
      2.364815,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.954624,
      1.482502,
      0.914688,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1.355251,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.941389,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2.482449,
      1,
      3,
      1.656546,
      2.355915,
      0,
      1.556799,
      0,
      1,
      1.589744,
      NULL,
      1,
      0.872573,
      1,
      1.507971,
      1,
      0.004569,
      1.286238,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.109023,
      '24232',
      '40000',
      '',
      0,
      '',
      '',
      '',
      4,
      '4022',
      '2432',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


