set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902224';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-10-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      NULL,
      NULL,
      NULL,
      '1211323',
      50,
      2,
      NULL,
      NULL,
      NULL,
      0,
      ' 6-26-1995',
      32.130050,
      NULL,
      0,
      NULL,
      2.124170,
      0,
      0,
      0.495975,
      1.521143,
      1.397514,
      1,
      0.432095,
      0,
      NULL,
      3,
      1,
      0,
      0,
      9.713031,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.225375,
      0,
      2,
      1,
      4.433778,
      1.227543,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.470828,
      0.396833,
      2,
      NULL,
      1.159942,
      2,
      3.767037,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2.578398,
      NULL,
      0.733797,
      0.449930,
      0.532311,
      0,
      0,
      0.949460,
      0.245872,
      0,
      2,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      NULL,
      2.183845,
      1.433946,
      4.846390,
      1,
      NULL,
      0,
      1,
      0.440911,
      1,
      NULL,
      1.720725,
      0,
      1,
      0,
      0,
      1,
      1.245437,
      NULL,
      1.856109,
      6,
      1,
      1,
      0,
      NULL,
      3,
      NULL,
      0.293567,
      0,
      3,
      1,
      1,
      0,
      4.320454,
      4.046583,
      6,
      9.285168,
      7,
      6.490260,
      4.976292,
      2.494958,
      7.323126,
      7.999819,
      NULL,
      5.129331,
      12.591668,
      3,
      1.802306,
      0.052240,
      1.333821,
      3,
      1.947702,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      1.975087,
      0.150598,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.656311,
      NULL,
      NULL,
      NULL,
      NULL,
      1.758244,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.944143,
      3.627730,
      NULL,
      NULL,
      NULL,
      NULL,
      0.425810,
      1,
      0.182334,
      0.295553,
      1.031486,
      1,
      1.629054,
      NULL,
      NULL,
      NULL,
      1.675211,
      1.960579,
      0.565230,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.215934,
      2.770549,
      2.601923,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.622739,
      3,
      NULL,
      1.179066,
      0,
      0.223879,
      NULL,
      0.340188,
      NULL,
      1.920152,
      0.648788,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      '14243',
      '',
      0,
      '',
      '',
      '',
      2.673549,
      '1301',
      '4322',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


