set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902224';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-10-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '244',
      '04',
      NULL,
      15,
      NULL,
      102,
      NULL,
      NULL,
      0,
      '304404',
      5,
      ' 3- 0-1983',
      28,
      50.566187,
      NULL,
      NULL,
      0,
      0,
      3,
      0,
      3.509149,
      0.324029,
      NULL,
      1.658004,
      NULL,
      NULL,
      NULL,
      0,
      0.466528,
      0.293263,
      7,
      1,
      NULL,
      NULL,
      1.492004,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.450236,
      2.783827,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.615385,
      2,
      NULL,
      NULL,
      1,
      1.585953,
      NULL,
      1,
      1.640810,
      1.503163,
      1.472878,
      0,
      3.853537,
      2,
      0,
      3.621915,
      1,
      1.400128,
      NULL,
      1.434367,
      0,
      NULL,
      6.495085,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.579484,
      0.497711,
      2,
      0.231961,
      2.335937,
      0,
      0.510686,
      NULL,
      0.596972,
      1.337398,
      1,
      1.727845,
      0.073283,
      1.815948,
      1.350005,
      1.379910,
      1,
      NULL,
      0.005952,
      NULL,
      NULL,
      1.039882,
      0,
      0,
      NULL,
      NULL,
      2,
      NULL,
      2.462364,
      1,
      0.122595,
      0,
      5.534004,
      5,
      2.541011,
      2.751798,
      1,
      3,
      NULL,
      4.623414,
      7,
      5.007245,
      NULL,
      5.303962,
      3,
      NULL,
      5,
      NULL,
      1,
      1.283017,
      1,
      0.977077,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.940587,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.666097,
      3,
      0,
      0,
      1.063854,
      9.287863,
      2,
      0.739937,
      NULL,
      NULL,
      NULL,
      4,
      0.088432,
      1,
      3,
      1,
      NULL,
      1.557863,
      NULL,
      NULL,
      NULL,
      1.983357,
      2.625149,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2,
      0,
      NULL,
      1,
      1.717485,
      2,
      1.332289,
      1.376091,
      NULL,
      0,
      0,
      1.766085,
      0,
      1.868541,
      0.212779,
      1.424754,
      1.966968,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.834388,
      NULL,
      '01113',
      '',
      0.665941,
      NULL,
      '',
      '',
      1,
      '3011',
      NULL,
      '',
      3.584048,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


