set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902224';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-3-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '144',
      '04',
      24,
      2,
      '0103413',
      99,
      4,
      0.801808,
      NULL,
      '104043',
      2,
      ' 3-24-1996',
      3,
      38.979302,
      0.854144,
      NULL,
      1.499395,
      0.074209,
      3,
      1.086413,
      0,
      3,
      NULL,
      0.778622,
      0,
      NULL,
      0,
      1,
      0,
      4,
      5,
      3.885586,
      NULL,
      0,
      NULL,
      NULL,
      0.252093,
      0.669982,
      0,
      1,
      NULL,
      2.318086,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      10,
      3.842588,
      2,
      2,
      0,
      NULL,
      2,
      1,
      0.628795,
      0,
      NULL,
      0.240835,
      3,
      3.451773,
      2.971173,
      1,
      NULL,
      1,
      1.607827,
      0.595259,
      1,
      1,
      2,
      0,
      NULL,
      3.914402,
      1.193807,
      NULL,
      NULL,
      0.880027,
      NULL,
      NULL,
      5.025323,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.793917,
      0,
      0.718297,
      1,
      1.815998,
      0.954997,
      1.706097,
      1,
      0,
      1,
      0.380822,
      NULL,
      0.723531,
      NULL,
      0,
      NULL,
      1,
      1.902866,
      4.667347,
      1,
      7.690686,
      0,
      1,
      1.568641,
      0.946590,
      1.850023,
      4,
      0,
      0,
      6.904184,
      3,
      7,
      7,
      2.729182,
      NULL,
      NULL,
      NULL,
      9.282349,
      5,
      1.128117,
      4.213202,
      0,
      1.641574,
      1,
      0.129722,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.805957,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.238720,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.810237,
      1.197105,
      0.842543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.393000,
      NULL,
      NULL,
      NULL,
      1,
      5,
      0.095289,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.001618,
      1.117771,
      0.955028,
      1,
      0,
      3.722050,
      NULL,
      0,
      0,
      1,
      1,
      1.784135,
      0.339077,
      0.594045,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.669292,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.671560,
      NULL,
      NULL,
      '',
      0.638934,
      '',
      NULL,
      '',
      5.617324,
      NULL,
      NULL,
      '',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


