set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902224';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-9-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '300',
      NULL,
      18.232119,
      18.478223,
      NULL,
      NULL,
      4,
      2.823468,
      3,
      '034002',
      1,
      ' 9-18-1981',
      10,
      71,
      1,
      NULL,
      3.054836,
      NULL,
      2,
      1.321336,
      1,
      2.522133,
      0.267384,
      0.406512,
      3.771443,
      0,
      3.580883,
      0,
      0.284319,
      3.310915,
      6,
      NULL,
      6,
      1.847855,
      0.375781,
      0.289855,
      0,
      0,
      NULL,
      0,
      3.504613,
      2,
      0.517836,
      0.013984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.615904,
      NULL,
      2,
      NULL,
      0.692538,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      3,
      0.242762,
      NULL,
      1,
      1,
      1,
      0.096701,
      2,
      1.608222,
      2.757080,
      5.977561,
      1,
      2,
      2.198625,
      1.035455,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1.525989,
      2.532378,
      1,
      NULL,
      0,
      0,
      1.207183,
      1,
      1.661863,
      0.503562,
      0,
      0,
      0,
      1,
      NULL,
      1.688029,
      NULL,
      0,
      3,
      0,
      4,
      2.765622,
      0.091885,
      5,
      0.545359,
      4,
      0,
      0,
      NULL,
      5.402022,
      1.103953,
      NULL,
      5,
      4,
      0.247934,
      NULL,
      5,
      4.528382,
      NULL,
      3,
      3,
      2,
      5.584272,
      3.140344,
      0,
      3,
      NULL,
      NULL,
      3.063976,
      0.018942,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0.088995,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0.996198,
      0.711784,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.577128,
      NULL,
      0.748686,
      NULL,
      1.579618,
      NULL,
      NULL,
      NULL,
      0.521927,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.122509,
      3,
      0,
      1.231649,
      3.689862,
      2.249842,
      1.261589,
      1.860974,
      NULL,
      0.774437,
      0,
      0.311048,
      NULL,
      1.862245,
      1.576284,
      1,
      1.069160,
      NULL,
      1.811234,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4.173769,
      '03222',
      '43213',
      '',
      1,
      '',
      '',
      NULL,
      0.166068,
      '3403',
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


