set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902224';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-3-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '00',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      ' 9-19-1985',
      24,
      109,
      1.872792,
      NULL,
      1,
      3,
      0,
      1.817288,
      NULL,
      1,
      NULL,
      1,
      0.219414,
      0,
      1.909864,
      0.908365,
      0,
      0,
      7,
      1,
      2,
      3.148444,
      NULL,
      1,
      9,
      NULL,
      7.071984,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.609124,
      3.522788,
      0.228528,
      2.665985,
      0.503024,
      1,
      NULL,
      1,
      2.355729,
      1.468709,
      0,
      1,
      NULL,
      3.644856,
      1.181592,
      1.683279,
      0,
      0,
      NULL,
      0.793581,
      1,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0.372850,
      NULL,
      NULL,
      0.360538,
      NULL,
      NULL,
      1,
      NULL,
      5,
      1.289750,
      2,
      4.396658,
      2.051438,
      1,
      0,
      1,
      NULL,
      4,
      0.931863,
      2.578885,
      NULL,
      NULL,
      1.330682,
      0,
      0,
      NULL,
      0,
      1.215528,
      3,
      3.556288,
      0.516244,
      1.348424,
      0,
      1.564445,
      4.995123,
      1,
      0.418338,
      0.812123,
      2,
      NULL,
      2,
      1.576406,
      1,
      3,
      NULL,
      4,
      0,
      1,
      4,
      NULL,
      4,
      1.250262,
      3.841058,
      6.487562,
      3.452550,
      0.216242,
      0.709756,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.412283,
      1,
      0,
      0,
      NULL,
      NULL,
      1.027598,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.564011,
      0.764882,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.778915,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.842730,
      NULL,
      0.391665,
      NULL,
      1,
      1,
      0,
      3,
      1.736709,
      NULL,
      3.852991,
      0.215790,
      NULL,
      0.669701,
      NULL,
      0.321854,
      1,
      0.686852,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.433120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      '11020',
      '42430',
      '',
      NULL,
      '',
      '',
      '',
      5.332566,
      '4314',
      '3201',
      '',
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


