set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902224';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-9-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '124',
      '22',
      0.348178,
      22.459325,
      '4114010',
      90.416208,
      NULL,
      2,
      0,
      '132413',
      1,
      NULL,
      22,
      43,
      NULL,
      NULL,
      3,
      0.152773,
      3,
      0,
      0,
      3.008852,
      1.720806,
      1,
      3,
      1,
      1,
      0,
      1.807395,
      6.109172,
      3.930119,
      NULL,
      4,
      NULL,
      NULL,
      0.294293,
      0,
      1,
      1.115881,
      1,
      5,
      0,
      NULL,
      0.441809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.753141,
      2.605848,
      0,
      1,
      0.807813,
      0,
      1.613045,
      1.664129,
      0.679440,
      1,
      0,
      NULL,
      1.941414,
      2,
      2,
      NULL,
      0.054176,
      0.043703,
      0,
      0.676927,
      0.895206,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.388533,
      0,
      2.973039,
      1.386987,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      0.987002,
      0.323771,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3.215261,
      2,
      7,
      2.301790,
      0,
      5,
      0,
      0.378081,
      1,
      1,
      1.830618,
      NULL,
      NULL,
      1.012777,
      NULL,
      0.170046,
      6,
      NULL,
      0.632544,
      2.157503,
      6.611897,
      7.612709,
      2.867619,
      7,
      1,
      0.036938,
      1,
      NULL,
      0,
      NULL,
      8,
      1.330790,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.628308,
      1,
      NULL,
      0,
      1,
      0.603348,
      1.037787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.573884,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.710711,
      NULL,
      0.402385,
      NULL,
      NULL,
      NULL,
      0.886522,
      1.536585,
      NULL,
      0,
      0.864651,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.300172,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.872827,
      0.944549,
      1,
      NULL,
      1.135163,
      NULL,
      1,
      3.368508,
      1,
      0,
      NULL,
      0.151216,
      1.260305,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.538526,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.673965,
      NULL,
      '10143',
      NULL,
      1,
      '',
      '',
      NULL,
      4.016901,
      '0134',
      NULL,
      '',
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


