set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902224';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-10-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '333',
      '01114330',
      NULL,
      20.975212,
      '2120104',
      105,
      6,
      3,
      3,
      '132020',
      3.778855,
      ' 0-14-2000',
      NULL,
      16.449856,
      0,
      NULL,
      NULL,
      1.791660,
      1.268145,
      0,
      1,
      2.152778,
      0,
      0,
      3,
      1,
      1,
      1,
      0.246772,
      3,
      NULL,
      NULL,
      2,
      1,
      0,
      0.297883,
      3,
      1,
      6.780690,
      3,
      3.876912,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.766907,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.216097,
      1,
      NULL,
      NULL,
      0,
      2,
      2,
      0.810194,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.353386,
      0,
      2.697953,
      1.009230,
      0,
      NULL,
      2.639124,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      5.329508,
      0,
      NULL,
      NULL,
      1.507978,
      1,
      NULL,
      1,
      2,
      NULL,
      1.278410,
      NULL,
      0,
      7,
      0.420052,
      1.786674,
      NULL,
      5,
      2.475910,
      2,
      0.887380,
      5,
      NULL,
      NULL,
      4,
      2.205362,
      6,
      6.523350,
      3,
      7,
      4,
      0,
      1.353940,
      NULL,
      6,
      NULL,
      NULL,
      1,
      0.079319,
      1.277201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.550632,
      NULL,
      1,
      NULL,
      NULL,
      1.312065,
      1.801858,
      0.709370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.393129,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.783099,
      NULL,
      NULL,
      2.856843,
      NULL,
      1,
      1.243619,
      NULL,
      NULL,
      NULL,
      NULL,
      3.589286,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.260373,
      1.316577,
      NULL,
      2.967189,
      3.560361,
      NULL,
      0.725709,
      2.375215,
      NULL,
      0.969050,
      1,
      1.817132,
      1.589189,
      0,
      NULL,
      1,
      1,
      1.950656,
      1.483918,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '21421',
      '34442',
      '',
      1,
      '',
      NULL,
      '',
      2,
      '4030',
      '3011',
      '',
      NULL,
      1,
      NULL,
      1,
      3.648530,
      NULL,
      0,
      NULL,
      NULL);
commit;
end;
/


