set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902224';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-3-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '414',
      NULL,
      44,
      28,
      NULL,
      140.764007,
      6,
      3,
      2,
      '312410',
      NULL,
      ' 8-16-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      2.878006,
      1.528926,
      0,
      0.718870,
      0,
      2.797723,
      1,
      1,
      NULL,
      1.363338,
      0,
      0,
      NULL,
      7.834253,
      8,
      0,
      NULL,
      2,
      NULL,
      NULL,
      1.449581,
      3.189978,
      8,
      0,
      NULL,
      2.314244,
      1.484748,
      1.834943,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1.806853,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      0.569851,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.695714,
      4,
      3,
      NULL,
      0.000316,
      5.509876,
      NULL,
      NULL,
      1.893241,
      0.832977,
      2,
      NULL,
      NULL,
      0,
      0.685224,
      0.502604,
      1.836145,
      1.397398,
      NULL,
      0,
      0,
      4.863297,
      0,
      NULL,
      1,
      NULL,
      1,
      2.579799,
      1,
      1,
      2,
      0,
      1.799131,
      3,
      1.949234,
      0,
      NULL,
      3.402987,
      3,
      3.074011,
      NULL,
      NULL,
      7.412637,
      1,
      2,
      5.728639,
      3.731149,
      0,
      NULL,
      1.925812,
      0,
      1.779095,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.286904,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.496027,
      1.018245,
      NULL,
      NULL,
      NULL,
      0.911913,
      0.213127,
      0.283766,
      7,
      1.107871,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.628580,
      7.403229,
      0.100960,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.895451,
      1,
      2,
      NULL,
      2.581640,
      3.658613,
      NULL,
      3,
      1,
      1.082486,
      0.199136,
      0.208714,
      NULL,
      1.293753,
      1,
      1.832377,
      0,
      0,
      0.860481,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.044480,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.600309,
      '43142',
      '11320',
      NULL,
      1.122182,
      '',
      '',
      '',
      3.660024,
      '0122',
      '1212',
      NULL,
      NULL,
      0.053012,
      NULL,
      0,
      2.258481,
      2,
      3,
      0.899612,
      2);
commit;
end;
/


