set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902224';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-8-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '404',
      '44032113',
      NULL,
      24,
      '1144320',
      223,
      6,
      0.386941,
      0,
      '430242',
      3.210697,
      NULL,
      NULL,
      35,
      1,
      NULL,
      3,
      0.796785,
      2.469270,
      0,
      0,
      NULL,
      0.819121,
      0,
      2,
      1,
      2,
      1,
      0.778740,
      0.649058,
      NULL,
      0.550681,
      2.569108,
      1,
      1.638727,
      2,
      0.422810,
      1.227067,
      5,
      1,
      2,
      0.215115,
      5.651371,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0,
      1.513915,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.280272,
      8,
      6,
      NULL,
      2,
      3.744149,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      4.777213,
      3,
      3.238843,
      0,
      0,
      3.773866,
      0.317051,
      1,
      0.393590,
      0.283661,
      NULL,
      0.352829,
      0,
      0.632453,
      0,
      1.148327,
      1,
      1,
      NULL,
      1,
      4.921438,
      0.576969,
      0.266192,
      2.205617,
      1,
      6,
      0,
      3,
      NULL,
      1.421348,
      NULL,
      5,
      1.587483,
      4.440978,
      NULL,
      1,
      2.276341,
      7,
      NULL,
      4.971238,
      2,
      5.285896,
      NULL,
      1.567094,
      1,
      2,
      6.356768,
      2,
      0,
      1.696874,
      2.655310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.356783,
      NULL,
      NULL,
      1,
      1,
      0.578779,
      0,
      0.853065,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.760118,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.896570,
      1.886780,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      5.140574,
      0,
      2,
      1.974360,
      0.509247,
      NULL,
      NULL,
      0,
      0.886638,
      0.439217,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.245819,
      3,
      1.945132,
      1.058603,
      1.758157,
      3,
      NULL,
      0.511042,
      0,
      NULL,
      NULL,
      0.257206,
      NULL,
      1,
      1.806621,
      1.997674,
      0.506790,
      1,
      1.823809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.657380,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.883393,
      '02013',
      '34220',
      '',
      NULL,
      NULL,
      NULL,
      '',
      1,
      '2332',
      '4011',
      '',
      4,
      3,
      NULL,
      NULL,
      3.666073,
      2.942430,
      1,
      3.204209,
      3.578339);
commit;
end;
/


