set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902224';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-3-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '231',
      NULL,
      1.522044,
      27,
      '0110444',
      70,
      5,
      3.227333,
      3,
      '003004',
      4.388723,
      ' 4-12-1976',
      NULL,
      NULL,
      1,
      NULL,
      1.287875,
      2,
      1.226043,
      1.361873,
      NULL,
      0.124080,
      0,
      0,
      3.442311,
      1,
      0.348348,
      0.899304,
      NULL,
      3,
      2.288868,
      0,
      1,
      0.350042,
      2.339068,
      NULL,
      2,
      NULL,
      NULL,
      2,
      4,
      2,
      NULL,
      1.601201,
      NULL,
      NULL,
      0.638125,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.857055,
      7.335295,
      7,
      2,
      2,
      5,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.720180,
      NULL,
      2.695494,
      1.607729,
      5,
      NULL,
      NULL,
      0.712018,
      0,
      0.057047,
      0,
      7.072415,
      NULL,
      4,
      1,
      NULL,
      1.815373,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.530695,
      0.848416,
      0,
      4,
      1,
      1.856376,
      0.817269,
      0,
      3.021282,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      5.689627,
      7.242713,
      NULL,
      NULL,
      3.329436,
      3,
      2,
      NULL,
      NULL,
      0,
      3,
      0.484627,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.874525,
      NULL,
      0,
      0,
      0.599452,
      1.099753,
      1.621568,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2.856849,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.119043,
      0,
      4.891757,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.152750,
      0,
      0.136852,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.078798,
      NULL,
      0,
      2.967627,
      0,
      2.846075,
      1.749977,
      2.779259,
      0.843708,
      2,
      0,
      0.690448,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '11023',
      '20402',
      '',
      1,
      '',
      NULL,
      '',
      1,
      '0430',
      '3003',
      NULL,
      5.436716,
      0,
      1.351147,
      0,
      0.399552,
      2.056333,
      1.982184,
      2,
      2.582632);
commit;
end;
/


