set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902224';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-8-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '040',
      NULL,
      10.430651,
      40,
      '0140403',
      146.562736,
      3,
      1.813447,
      NULL,
      '244110',
      3,
      ' 6-21-2001',
      14.875635,
      19,
      NULL,
      NULL,
      3.596854,
      NULL,
      2,
      1.879819,
      0.286172,
      3.444599,
      1.102160,
      1.318002,
      1.737863,
      NULL,
      5.394275,
      1.325907,
      0.502749,
      5,
      NULL,
      5.426207,
      0.409664,
      9,
      0.565720,
      2,
      NULL,
      NULL,
      NULL,
      3,
      4.327373,
      3,
      5.612100,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      0.474268,
      NULL,
      NULL,
      0,
      3,
      1.276701,
      3.030271,
      1,
      2.024494,
      0.098104,
      0,
      2,
      2.373089,
      NULL,
      NULL,
      3.943569,
      2.554930,
      2,
      NULL,
      0,
      2,
      0,
      2,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.207222,
      5,
      NULL,
      1,
      5.266401,
      7,
      NULL,
      1,
      1,
      NULL,
      4,
      2.523315,
      3,
      0.087651,
      1,
      0.504249,
      1.943573,
      NULL,
      1.452698,
      NULL,
      1.340065,
      1,
      4,
      4.660845,
      NULL,
      0,
      1,
      0.772012,
      3,
      0,
      1,
      NULL,
      3.206884,
      1,
      4,
      0,
      1,
      4,
      NULL,
      0.093348,
      NULL,
      0.447260,
      NULL,
      6.347595,
      8.215793,
      5,
      6.316604,
      5,
      2,
      1.204893,
      0.503063,
      0,
      1.199692,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      0.622790,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.596539,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.621926,
      3.042740,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.841921,
      2.400520,
      6,
      1.135898,
      1,
      1.537442,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.975913,
      0.325587,
      NULL,
      2,
      NULL,
      2.558500,
      NULL,
      2.804119,
      1,
      0.626845,
      NULL,
      0.314405,
      0,
      0.950235,
      NULL,
      0.794656,
      1,
      0.186076,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.050361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.089076,
      '24334',
      '22334',
      '',
      0,
      '',
      NULL,
      '',
      3.151223,
      '4423',
      '0020',
      '',
      5,
      3,
      1.902488,
      1.212598,
      2.116128,
      1.263757,
      1.590281,
      3.427451,
      2.054712);
commit;
end;
/


