set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902224';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-9-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '140',
      '34104120',
      56.796314,
      51,
      '3021413',
      153.838740,
      5,
      0,
      1,
      '123432',
      5.468966,
      '11- 3-1993',
      NULL,
      55,
      1.839942,
      NULL,
      1,
      0.919122,
      2.005438,
      0.494691,
      1,
      2.175395,
      1.290410,
      0.690065,
      3.332875,
      1,
      NULL,
      1.161532,
      NULL,
      NULL,
      1.753418,
      0.338422,
      4,
      0,
      NULL,
      0,
      0,
      NULL,
      0.135196,
      1,
      2.211993,
      NULL,
      0,
      0.815951,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.803297,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0.583747,
      0.883485,
      0,
      0.095940,
      1.592006,
      NULL,
      1.803894,
      0.451726,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      5,
      1,
      1.359912,
      2,
      1,
      4,
      1,
      4.738499,
      3,
      5,
      0.325360,
      NULL,
      0,
      4.499453,
      0,
      0,
      1,
      1,
      1.622404,
      0,
      7.099512,
      0,
      0,
      3.369242,
      3,
      NULL,
      NULL,
      1.850568,
      NULL,
      NULL,
      1.921096,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.659525,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.273392,
      NULL,
      NULL,
      NULL,
      NULL,
      1.626030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.649806,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.935320,
      NULL,
      2.724663,
      NULL,
      1.537760,
      NULL,
      1.678952,
      NULL,
      NULL,
      NULL,
      1,
      0.873910,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.610449,
      0,
      0,
      3.112486,
      NULL,
      0,
      2,
      1,
      3,
      1,
      1,
      NULL,
      0.732906,
      1,
      1,
      0.164853,
      1.405576,
      1.959048,
      0.061139,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      '41200',
      '12440',
      '',
      NULL,
      '',
      NULL,
      '',
      5,
      NULL,
      '4134',
      '',
      4,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2,
      NULL);
commit;
end;
/


