set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902224';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-3-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '103',
      '03121023',
      18,
      45,
      NULL,
      127.837323,
      NULL,
      2,
      3,
      '400144',
      5,
      '10-13-1980',
      22,
      26,
      NULL,
      NULL,
      NULL,
      0.131760,
      2.605795,
      0.452775,
      1.537237,
      2.805008,
      1,
      1.413009,
      2.886460,
      0,
      0,
      NULL,
      NULL,
      3,
      5,
      NULL,
      0.080429,
      0.908383,
      0,
      1,
      0,
      0.819821,
      4,
      0,
      2,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.434746,
      1,
      0.852042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.782625,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.702450,
      0,
      1.439344,
      1,
      0.018260,
      0.385101,
      1.873481,
      NULL,
      0.303289,
      1.974800,
      1.552935,
      NULL,
      NULL,
      NULL,
      1,
      1.228771,
      0.757243,
      0,
      NULL,
      1.061784,
      0,
      1.883992,
      0,
      0.016854,
      1.815861,
      3,
      0,
      1,
      0.141115,
      1.255268,
      1,
      NULL,
      0,
      1.428271,
      3,
      NULL,
      1.067485,
      5,
      2,
      0.602515,
      3.064707,
      0,
      5.121894,
      2,
      3,
      3.541053,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.323827,
      0.909234,
      1,
      0,
      0.510273,
      NULL,
      1.148770,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.889284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.506757,
      1.619505,
      NULL,
      NULL,
      NULL,
      1.065049,
      1,
      1.478013,
      1,
      1,
      1,
      1.390387,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.049395,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.551598,
      1,
      NULL,
      0.382241,
      NULL,
      0.188556,
      0.229256,
      1.688190,
      0.548293,
      NULL,
      1,
      0,
      NULL,
      0,
      1.016338,
      1,
      1,
      0,
      0.257535,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.680258,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '40344',
      NULL,
      '',
      0,
      '',
      '',
      '',
      NULL,
      '3342',
      '4344',
      NULL,
      5.974384,
      1.002334,
      NULL,
      2,
      NULL,
      2.428226,
      0,
      2,
      1.767131);
commit;
end;
/


