set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9845663';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-3-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '102',
      '04311212',
      68,
      NULL,
      '4002303',
      NULL,
      NULL,
      2,
      1,
      NULL,
      3,
      '10-22-1987',
      55.673843,
      36.209478,
      0,
      NULL,
      1,
      1,
      NULL,
      0.391432,
      0.191628,
      1,
      2,
      NULL,
      NULL,
      1.973775,
      1.954447,
      1,
      1.763938,
      1.675079,
      0.585111,
      0,
      1.965073,
      1,
      1.419485,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.414491,
      0,
      0,
      1,
      1,
      0,
      NULL,
      3,
      0.081632,
      0.038405,
      2.587584,
      0.987726,
      1.446566,
      1,
      2.811057,
      2,
      1.391802,
      1,
      NULL,
      5,
      0.394476,
      2.125196,
      1,
      2,
      0,
      1.686043,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.843258,
      1,
      0.163816,
      0.806217,
      1.742056,
      1.200966,
      0.380148,
      1,
      1,
      NULL,
      1.192079,
      0,
      1,
      1,
      1.043323,
      0,
      1,
      0.922379,
      NULL,
      0,
      1,
      NULL,
      0,
      1.747561,
      1.031004,
      1,
      0,
      NULL,
      5.352508,
      5.565830,
      0.948446,
      2.002276,
      2.753906,
      NULL,
      3,
      0,
      3.732882,
      6.252906,
      3,
      NULL,
      5,
      5,
      5.050403,
      5,
      5.153352,
      1.215453,
      2,
      NULL,
      NULL,
      NULL,
      1,
      0.607379,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.340729,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1.799158,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      4,
      1,
      1,
      3,
      1,
      3.937056,
      1.901135,
      NULL,
      0,
      2.584308,
      1.837573,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      8.495725,
      2.933190,
      3.883465,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.836667,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.365335,
      1.418166,
      NULL,
      1.121375,
      2,
      3.890304,
      3.011995,
      1.797239,
      0,
      2.591946,
      1,
      NULL,
      1.628300,
      1.477098,
      0,
      1.312713,
      1,
      1.499834,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '22303',
      '40342',
      '1423',
      1.251310,
      '',
      NULL,
      NULL,
      1.157610,
      NULL,
      '',
      '',
      1.695329,
      0,
      2.780437,
      NULL,
      3,
      NULL,
      0.012256,
      2,
      NULL);
commit;
end;
/


