set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9845663';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-8-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '330',
      '00231223',
      68,
      NULL,
      '3144301',
      24.448846,
      5,
      2.919741,
      1,
      '113222',
      6.146817,
      '11- 7-1994',
      NULL,
      52.879286,
      1,
      NULL,
      NULL,
      0.883454,
      0,
      1.399855,
      3.897523,
      0.252144,
      1.423284,
      1,
      1.303172,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.481822,
      NULL,
      3,
      1,
      1.564255,
      NULL,
      1,
      NULL,
      0.305901,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.032508,
      0,
      0.131464,
      NULL,
      NULL,
      2,
      2.438413,
      1,
      0.523352,
      2.073940,
      2.006580,
      0,
      1.414664,
      0.757054,
      1,
      3.825986,
      NULL,
      1,
      3.933659,
      1.713485,
      1.564939,
      4,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.422787,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3,
      4,
      1,
      1.639533,
      0.014315,
      0,
      0.774255,
      NULL,
      0.562469,
      1.902706,
      1,
      0,
      0,
      1,
      1.804636,
      1.462544,
      NULL,
      0.152335,
      5,
      1.777017,
      1,
      5,
      NULL,
      0,
      0,
      5.191909,
      1.082237,
      NULL,
      NULL,
      4.458930,
      NULL,
      1.380952,
      0,
      NULL,
      2.398442,
      3,
      NULL,
      3.454704,
      3.598063,
      6.641125,
      7,
      8.536660,
      5,
      1.960190,
      4,
      0.530435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.226898,
      1,
      2,
      0,
      1.956659,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2,
      3.031766,
      NULL,
      1.509543,
      1,
      2.590005,
      0,
      NULL,
      0.177644,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.133674,
      1.185900,
      2.269626,
      1,
      1.553736,
      NULL,
      NULL,
      NULL,
      1.430101,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.144289,
      1,
      2,
      3,
      1,
      3.566044,
      1.090933,
      NULL,
      0,
      1,
      1.521264,
      1.151152,
      0,
      1,
      0.280796,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.759214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6.235758,
      '10434',
      '20004',
      '0211',
      1,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      2,
      NULL,
      1.870480,
      3,
      0,
      5,
      0,
      0,
      1);
commit;
end;
/


