set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9845663';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-3-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '340',
      '34304012',
      25.369591,
      42,
      '2004042',
      3,
      6,
      2.735248,
      3,
      '112201',
      0,
      ' 1-15-1996',
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.531938,
      0,
      1.625288,
      NULL,
      1.656532,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.603125,
      NULL,
      NULL,
      1,
      NULL,
      1.700575,
      1,
      1.936040,
      NULL,
      1.682591,
      4,
      1,
      NULL,
      0,
      1,
      1.894960,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.106230,
      0.419982,
      1,
      NULL,
      1.348787,
      1.815508,
      0,
      3.637462,
      2,
      1,
      0.012036,
      0,
      1.797828,
      NULL,
      0,
      0,
      NULL,
      0,
      0.013720,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.566242,
      0.565105,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2,
      1,
      1,
      1,
      NULL,
      NULL,
      0.463806,
      NULL,
      NULL,
      1,
      1.794939,
      0.823037,
      0.547476,
      1,
      0.991377,
      1,
      0,
      1.492099,
      NULL,
      1.640659,
      2,
      1,
      NULL,
      0.746077,
      1.963627,
      NULL,
      0,
      3,
      5,
      5,
      0,
      NULL,
      0,
      4.395106,
      2,
      4.033172,
      NULL,
      8.096585,
      4.030309,
      3,
      NULL,
      1.372098,
      4,
      3.986187,
      2.548200,
      0.269366,
      5.450219,
      1.949749,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.464265,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.511410,
      1,
      0.223558,
      1,
      2.210657,
      4.596724,
      1.713151,
      1.815979,
      NULL,
      NULL,
      NULL,
      4.286316,
      1,
      4.137683,
      5,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.860755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.388151,
      NULL,
      NULL,
      1,
      2.227016,
      1.669754,
      NULL,
      1.657060,
      0.907008,
      0.434184,
      1,
      0,
      0.103266,
      1.115857,
      0.473969,
      1.203721,
      NULL,
      0.816121,
      0.017830,
      1.621356,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6,
      NULL,
      '24114',
      '0022',
      1,
      '',
      '',
      '',
      2,
      '1222',
      '',
      '',
      5,
      1.461484,
      0,
      0,
      3.260041,
      1,
      1,
      2,
      5);
commit;
end;
/


