set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9845663';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-9-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1241',
      '03023112',
      47,
      17,
      NULL,
      19.002265,
      1,
      1,
      3,
      NULL,
      6.114608,
      ' 1- 6-1987',
      12,
      37.887208,
      NULL,
      NULL,
      1,
      0,
      1.644122,
      1.267231,
      0.946315,
      0.016154,
      1.360978,
      0,
      2,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.428333,
      2,
      NULL,
      1,
      0.929743,
      NULL,
      0,
      0.891830,
      0,
      NULL,
      NULL,
      0.463039,
      NULL,
      NULL,
      NULL,
      0.156211,
      NULL,
      NULL,
      NULL,
      1.956185,
      0,
      NULL,
      NULL,
      1.791505,
      2.969533,
      1.881755,
      0.816143,
      1.286371,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.977836,
      1.345152,
      1.599660,
      1,
      NULL,
      NULL,
      0.672313,
      NULL,
      0,
      NULL,
      0,
      1.302722,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.887616,
      4,
      1,
      1.676228,
      2,
      1,
      NULL,
      1,
      1.264029,
      0,
      0.111671,
      NULL,
      NULL,
      0.028370,
      0.116009,
      1.633622,
      1.402875,
      NULL,
      1.104020,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.392391,
      1.339595,
      5.500474,
      0,
      1.185488,
      4.451811,
      4,
      NULL,
      0.078184,
      0,
      2,
      1.112865,
      NULL,
      NULL,
      5.514309,
      1,
      2.203322,
      9.687792,
      NULL,
      NULL,
      3,
      3.942725,
      1.999967,
      5,
      0,
      NULL,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.761624,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.795667,
      0,
      NULL,
      NULL,
      NULL,
      5,
      1,
      6,
      5,
      0.607536,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.632950,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.332182,
      0,
      2,
      1,
      3,
      1.093206,
      1,
      NULL,
      0.300748,
      3.646299,
      1.565653,
      NULL,
      NULL,
      0.363349,
      1,
      NULL,
      0.869262,
      0.478855,
      0.649467,
      0.473375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.492252,
      '22134',
      NULL,
      '4233',
      1,
      NULL,
      '',
      '',
      NULL,
      '4000',
      NULL,
      '',
      0.800832,
      1,
      0,
      4,
      0,
      1.797033,
      2.346814,
      1,
      1.172525);
commit;
end;
/


