set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9845663';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1432',
      '43241111',
      24,
      NULL,
      '0012031',
      33,
      4,
      1.860793,
      0,
      '120330',
      3.908971,
      ' 3- 0-1989',
      45.771370,
      13.340054,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.441213,
      0,
      2,
      0,
      0.790290,
      3,
      0,
      5,
      0.441389,
      0.135540,
      1,
      NULL,
      1,
      NULL,
      0.672334,
      1,
      NULL,
      0.646931,
      1.991285,
      3,
      NULL,
      1,
      1.394989,
      1,
      NULL,
      NULL,
      NULL,
      0.901685,
      NULL,
      NULL,
      NULL,
      0.042964,
      0,
      1,
      0.618717,
      0,
      0,
      1,
      3.912387,
      0.058603,
      0,
      NULL,
      0,
      1.356349,
      NULL,
      NULL,
      3,
      0.292473,
      1.508574,
      NULL,
      NULL,
      0,
      0.005461,
      1,
      0,
      0.914199,
      0.974428,
      NULL,
      NULL,
      1.076376,
      NULL,
      NULL,
      0.852329,
      5,
      NULL,
      NULL,
      NULL,
      0.354738,
      1,
      1,
      1,
      1.339796,
      NULL,
      0,
      NULL,
      0.463069,
      1,
      1.899899,
      0.532353,
      1,
      0,
      NULL,
      0,
      0.631651,
      1,
      0,
      1.108909,
      NULL,
      0,
      0,
      NULL,
      1,
      0.416791,
      0,
      0.211032,
      1,
      2,
      0.435177,
      0.569711,
      6,
      7.035242,
      8.411152,
      7,
      2.945237,
      4.715340,
      3,
      5.594905,
      NULL,
      0.185539,
      NULL,
      1.450570,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.088372,
      0,
      0,
      1.236679,
      1.885549,
      1,
      0.288086,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.309088,
      0,
      3.283450,
      1,
      1,
      3.153497,
      6,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2,
      0.332322,
      2,
      NULL,
      1.027695,
      NULL,
      NULL,
      NULL,
      0.469261,
      3.136631,
      1.676487,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.117193,
      NULL,
      0.239553,
      1.506342,
      NULL,
      0.263615,
      1,
      1.672244,
      2.693068,
      NULL,
      NULL,
      0,
      0.922442,
      1.686648,
      NULL,
      0,
      1,
      1.010017,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.514667,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.270597,
      '01013',
      '30211',
      '4004',
      1.268711,
      '',
      '',
      '',
      0.697272,
      '0043',
      '',
      NULL,
      3,
      2.988808,
      NULL,
      NULL,
      0.865973,
      1,
      1,
      0.440539,
      3.579914);
commit;
end;
/


