set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9845663';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-9-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0242',
      '44203113',
      NULL,
      7,
      '2011421',
      49,
      NULL,
      NULL,
      0,
      '423413',
      3,
      ' 4-23-1992',
      0,
      38,
      1.758238,
      NULL,
      0.697964,
      1.334449,
      1.924629,
      1,
      0.530007,
      1,
      1,
      0.615727,
      0.464988,
      1,
      NULL,
      0.616272,
      1,
      1,
      1.572431,
      0.460857,
      1.462788,
      1,
      0,
      NULL,
      NULL,
      0,
      0.525080,
      1,
      2.633757,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.554468,
      1.242520,
      1.659491,
      0,
      0.126974,
      1,
      NULL,
      NULL,
      2,
      1.628090,
      1.841611,
      1,
      NULL,
      0,
      1,
      1,
      0.580642,
      1,
      1,
      1,
      0.447182,
      NULL,
      0.864814,
      1,
      NULL,
      1.088086,
      1,
      NULL,
      NULL,
      0.237889,
      NULL,
      NULL,
      NULL,
      NULL,
      2.287467,
      NULL,
      3.694704,
      1,
      1,
      0.100418,
      1.621686,
      0.110566,
      1,
      NULL,
      0,
      3.262222,
      NULL,
      0.132271,
      1,
      0.464763,
      0,
      NULL,
      0.945231,
      3,
      NULL,
      0.634988,
      NULL,
      0.714177,
      NULL,
      1.067907,
      2.073848,
      1,
      1,
      0.410103,
      0.299935,
      NULL,
      1.042521,
      3,
      0.676644,
      5.840940,
      3.377440,
      7.097865,
      5,
      NULL,
      4.514967,
      3,
      5.401616,
      1,
      5,
      0,
      1,
      NULL,
      NULL,
      4,
      1.322165,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.789333,
      1,
      1,
      0,
      0.662249,
      0.483791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.521626,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      3,
      0.266212,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      4,
      NULL,
      2,
      1.751654,
      NULL,
      NULL,
      NULL,
      1.107417,
      2,
      1.691608,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.706912,
      1.582297,
      0,
      2.655060,
      NULL,
      0.217769,
      0.302368,
      0,
      1.638550,
      1,
      1.037997,
      1,
      NULL,
      1.867454,
      0,
      0,
      1,
      1,
      1.620576,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '22124',
      '21210',
      '3444',
      1,
      '',
      '',
      '',
      2.759728,
      '4210',
      NULL,
      NULL,
      1,
      0.404431,
      NULL,
      4,
      1,
      1,
      NULL,
      NULL,
      1.792894);
commit;
end;
/


