set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9845663';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-3-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '14232000',
      27,
      60,
      NULL,
      48,
      3,
      1,
      NULL,
      '304414',
      2.620217,
      ' 2-24-1977',
      NULL,
      NULL,
      0,
      NULL,
      1.877559,
      0.485525,
      1,
      0.528683,
      NULL,
      2,
      0.902189,
      1,
      NULL,
      0,
      1.916199,
      1,
      0.189202,
      NULL,
      0,
      0,
      4,
      0.500210,
      1.734537,
      1,
      0,
      0.458250,
      NULL,
      NULL,
      0.837352,
      0.604443,
      1.581615,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.622525,
      1,
      NULL,
      1,
      NULL,
      1.242623,
      1,
      3.851177,
      3.949769,
      1.909426,
      NULL,
      0,
      3,
      0,
      0.498662,
      0,
      1,
      0,
      1,
      1.415113,
      1,
      NULL,
      0,
      1,
      1.220434,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.155209,
      0.607515,
      NULL,
      NULL,
      0.851785,
      0,
      0.091033,
      0.266023,
      0,
      1,
      1,
      1,
      1.454867,
      NULL,
      0.505157,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      0.539818,
      0.835202,
      NULL,
      0,
      0,
      0.037802,
      NULL,
      1.305636,
      1,
      1,
      0,
      0.745973,
      NULL,
      4.034173,
      4,
      6.677650,
      2,
      5,
      4.857643,
      0,
      3,
      1.283240,
      3,
      0,
      NULL,
      NULL,
      NULL,
      6.581466,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.896852,
      1,
      1,
      1,
      1.688596,
      1.917128,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.533237,
      3,
      0.170134,
      NULL,
      NULL,
      NULL,
      0.569765,
      1.942413,
      5.041499,
      2.458167,
      5.935948,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.986289,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.215382,
      2,
      0,
      0,
      2,
      3,
      0.570297,
      0.742182,
      0,
      0,
      1.732770,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      0,
      1,
      1.368579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.721304,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.020175,
      '21020',
      '14133',
      '3111',
      1.602700,
      '',
      '',
      '',
      0,
      NULL,
      '2033',
      NULL,
      NULL,
      1.472847,
      4.167010,
      2,
      2.353309,
      NULL,
      3,
      NULL,
      3);
commit;
end;
/


