set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023505';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-4-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '0',
      NULL,
      NULL,
      '2142113',
      8,
      1,
      0.922020,
      NULL,
      '231123',
      0,
      '10- 3-1998',
      28.440371,
      NULL,
      1,
      NULL,
      NULL,
      0.075867,
      2.319479,
      1.530553,
      1.162280,
      3.401089,
      0.587307,
      0.739744,
      0.480938,
      0.160038,
      5.816025,
      2,
      0,
      1,
      NULL,
      1,
      3,
      0.218532,
      1,
      1.714868,
      1.094921,
      0,
      3.039377,
      0,
      5,
      0,
      1.917185,
      1.011179,
      NULL,
      NULL,
      1.955811,
      NULL,
      NULL,
      0.674252,
      NULL,
      1.125453,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.089636,
      1.762742,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.157361,
      NULL,
      0.340170,
      0,
      NULL,
      1.772354,
      1.700810,
      1,
      1.497318,
      0.503792,
      0.053497,
      1,
      0,
      NULL,
      1,
      1.502532,
      NULL,
      NULL,
      NULL,
      0.100031,
      NULL,
      1,
      NULL,
      0.046600,
      1,
      0.944093,
      1,
      5,
      1,
      0,
      0,
      NULL,
      2,
      5,
      5,
      1.335544,
      NULL,
      4,
      5.933737,
      NULL,
      0.771889,
      1.538819,
      7,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.026504,
      5.993776,
      NULL,
      0.010446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.706000,
      NULL,
      0,
      1,
      1,
      1,
      2,
      1.839100,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      7,
      3.207365,
      3.620378,
      1.215850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.021754,
      0.810634,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5.396380,
      2,
      6.214907,
      0,
      0.470202,
      NULL,
      NULL,
      NULL,
      0.067175,
      5.856858,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.368804,
      3,
      1,
      0.136799,
      3.538764,
      1,
      NULL,
      3.293850,
      0,
      0,
      3,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      1,
      0.983310,
      0.237778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.802279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      '31103',
      '41433',
      NULL,
      NULL,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


