set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023505';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-9-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '0',
      NULL,
      NULL,
      '0213440',
      13.754276,
      3,
      3,
      NULL,
      NULL,
      0.638765,
      ' 3-13-1999',
      12.116861,
      NULL,
      1.557513,
      NULL,
      3,
      1,
      1.078171,
      0,
      0.989095,
      2.760224,
      1,
      1,
      0,
      1.301020,
      2,
      1,
      0,
      1.732378,
      NULL,
      1,
      5.251412,
      NULL,
      NULL,
      0.517046,
      1,
      1.030544,
      2,
      NULL,
      NULL,
      0,
      1,
      1.979664,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.683778,
      1.641934,
      NULL,
      1.953435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.309771,
      1.473117,
      0.310015,
      0.611839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      1.777282,
      0,
      0,
      1,
      0,
      0,
      1.851697,
      NULL,
      0.638980,
      NULL,
      0.234331,
      1.420684,
      1.024134,
      0.653717,
      NULL,
      1.225402,
      1.473205,
      1,
      0.744748,
      1.090445,
      1,
      1.335457,
      1.168366,
      5.858000,
      0.770182,
      0.377592,
      0.827836,
      0.020980,
      0,
      0,
      1,
      1.763573,
      4.389531,
      0.842410,
      1.987746,
      0,
      0,
      2,
      7.569547,
      NULL,
      3.720648,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.809914,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.126807,
      NULL,
      NULL,
      1,
      1,
      0,
      1.790964,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.736312,
      NULL,
      9.858779,
      3.790133,
      NULL,
      2.197961,
      2.392812,
      3.140813,
      0.909160,
      1,
      2.513420,
      1.844852,
      0.287300,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.854147,
      4.662220,
      NULL,
      0,
      0.353779,
      NULL,
      NULL,
      NULL,
      0.672298,
      11.835236,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.291514,
      1,
      3.211300,
      NULL,
      0,
      0.074502,
      0.214524,
      3.082007,
      1,
      0.667282,
      1,
      1,
      1,
      NULL,
      0.121115,
      0,
      NULL,
      1.777874,
      0.827126,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      NULL,
      '33243',
      '32223',
      0,
      '',
      '',
      '',
      0,
      '22042',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


