set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023505';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-2-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '30',
      13.367912,
      NULL,
      NULL,
      NULL,
      3,
      2.215218,
      2,
      '204412',
      5.262892,
      ' 2- 2-2003',
      12,
      72,
      0,
      NULL,
      13,
      0,
      NULL,
      NULL,
      0.980141,
      NULL,
      0.704888,
      1.699495,
      0,
      0.783719,
      7,
      1.490787,
      1.691717,
      1,
      NULL,
      1.525685,
      NULL,
      0,
      1.494329,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.859437,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.331106,
      1,
      0.882572,
      1,
      0.066698,
      3,
      NULL,
      NULL,
      2.652121,
      1,
      NULL,
      1.099928,
      0,
      3.536414,
      1,
      3.854179,
      1,
      0,
      0,
      NULL,
      0.346286,
      2.436704,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      0.574557,
      NULL,
      NULL,
      0,
      NULL,
      5,
      0.011647,
      0,
      1,
      0.411955,
      1,
      0.519266,
      NULL,
      0.073043,
      1.914418,
      1,
      0.318521,
      0.438053,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3.351512,
      1.742874,
      0,
      0.675260,
      0.793384,
      3,
      1.994915,
      1.443187,
      NULL,
      0.001574,
      0,
      NULL,
      1,
      2,
      0,
      0,
      4.964933,
      6,
      1.866363,
      5.925068,
      NULL,
      NULL,
      5,
      NULL,
      1,
      0.123773,
      1.186168,
      3.032758,
      1.337094,
      1.549318,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      1.365171,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      1,
      2,
      3,
      1.457532,
      2.772320,
      0.631609,
      0.468538,
      NULL,
      5.345240,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.793968,
      1.198503,
      4.123026,
      2,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      0.634213,
      0.296931,
      0.898399,
      1.403098,
      3.265900,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1.319762,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '32121',
      '',
      '',
      0.768522,
      '',
      '',
      '',
      2.377157,
      '431',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


