set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023505';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-9-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '23',
      NULL,
      13.986825,
      '1002300',
      NULL,
      2,
      2,
      0,
      '131042',
      5,
      ' 5-28-1994',
      40,
      11,
      0.418986,
      NULL,
      0.298032,
      3,
      1.524762,
      0,
      3.765639,
      1.819999,
      0.928059,
      0.153590,
      0,
      0.592760,
      2.807046,
      0.275331,
      0,
      1.096407,
      1.654975,
      0,
      NULL,
      0.894365,
      1.699237,
      0,
      1,
      0.768009,
      5,
      0,
      2,
      NULL,
      1.723860,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.115008,
      1,
      NULL,
      2,
      1,
      NULL,
      0.425148,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.423871,
      1,
      7.622499,
      NULL,
      1,
      1.400937,
      5,
      1,
      1,
      0,
      1.824836,
      1,
      NULL,
      4.642849,
      0,
      NULL,
      1.162743,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3,
      1.033802,
      0,
      1.661730,
      NULL,
      4.173581,
      1,
      0,
      5,
      NULL,
      5.733840,
      NULL,
      7,
      3,
      NULL,
      7.623386,
      NULL,
      3.357619,
      2.969263,
      2,
      NULL,
      0,
      NULL,
      1,
      1,
      2.838899,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.716860,
      3.713795,
      0,
      0,
      1.117678,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      9.654706,
      3.375749,
      1,
      NULL,
      NULL,
      0.243521,
      2.631928,
      2,
      NULL,
      7,
      1.032520,
      3.340752,
      0,
      1.714599,
      0.797969,
      3,
      0,
      4,
      5.202948,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0,
      8.900213,
      0.682914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.964839,
      0.483547,
      1.684719,
      0.454829,
      NULL,
      1.866313,
      2,
      1.730497,
      NULL,
      3.848984,
      0.492964,
      1,
      1.992004,
      1.237972,
      1,
      0.653597,
      0.600427,
      0,
      1.778556,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.029258,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '14433',
      '',
      '',
      1.068580,
      '',
      '',
      '',
      0,
      '24021',
      '',
      '',
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


