set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023505';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-2-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '141',
      '01002313',
      50,
      40.796493,
      NULL,
      169.422457,
      NULL,
      1.173059,
      NULL,
      '104314',
      5.958361,
      ' 4-26-1992',
      NULL,
      NULL,
      1,
      NULL,
      1.702325,
      0,
      1.655132,
      1,
      0.624464,
      1,
      1.244640,
      1.072904,
      1,
      1,
      0,
      0.345215,
      0.106087,
      1.457482,
      0,
      NULL,
      0,
      1.057314,
      0,
      NULL,
      0,
      NULL,
      1.672784,
      0,
      2.680966,
      0.804559,
      0.684827,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.170289,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      4,
      1,
      NULL,
      1,
      1.029547,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      3,
      1,
      3.900385,
      0.245980,
      1,
      0,
      NULL,
      NULL,
      0.031977,
      NULL,
      0.238912,
      0,
      0,
      NULL,
      0.423774,
      0.039869,
      0,
      NULL,
      0,
      6.121716,
      1.675395,
      1.106346,
      NULL,
      1.998043,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.558731,
      1,
      4.932660,
      NULL,
      0,
      3,
      4.731585,
      4.481393,
      5.360074,
      0.672320,
      0.736258,
      3.992381,
      0.486997,
      3.716794,
      1.069628,
      NULL,
      1.053378,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0.333578,
      1.582823,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.805142,
      NULL,
      9.791843,
      2,
      0.361962,
      0.355288,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      1.801481,
      NULL,
      NULL,
      NULL,
      1,
      0.442868,
      2.706782,
      0.597747,
      1.647734,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.835374,
      NULL,
      1.730347,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.426444,
      0.096542,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.334923,
      1,
      0.007082,
      1,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '01311',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      1.259765,
      '04301',
      NULL,
      '',
      0,
      1.947207,
      3.162683,
      2,
      1,
      1,
      2,
      0.119972,
      2);
commit;
end;
/


