set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023505';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-8-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '244',
      '31304041',
      32,
      6,
      '1402431',
      NULL,
      4,
      3.432295,
      NULL,
      '443141',
      1,
      '11-13-1994',
      21,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2.684595,
      1,
      1.486033,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      1.884480,
      NULL,
      1,
      1,
      1.321757,
      1,
      0.184349,
      NULL,
      0,
      1.199528,
      0.906435,
      1.872096,
      1.864968,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1.181723,
      0.905817,
      0.193285,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.335048,
      0.858227,
      0.204626,
      1,
      0,
      1.193082,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.738654,
      NULL,
      2.148733,
      0,
      NULL,
      0,
      2,
      NULL,
      0.794119,
      1.558640,
      1.241938,
      1,
      1,
      2.748034,
      1,
      NULL,
      0.545835,
      1.834278,
      NULL,
      NULL,
      0.701162,
      3.626693,
      1,
      0,
      1,
      1,
      2.652965,
      1.398728,
      0.852581,
      1.424741,
      0,
      5.319801,
      2.593228,
      1.213984,
      1.780217,
      3.875586,
      4.437886,
      1.403050,
      NULL,
      NULL,
      7,
      NULL,
      2.452928,
      7,
      1.241778,
      2.316859,
      1.423851,
      1,
      0,
      NULL,
      NULL,
      5.660895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.117290,
      0.205975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.223965,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.054988,
      1.158908,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.828738,
      NULL,
      5.013267,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.760423,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.306778,
      1,
      0,
      0.883686,
      0,
      1,
      0,
      0,
      3.109888,
      1.366887,
      0,
      0.422840,
      NULL,
      0,
      0,
      0,
      0.255636,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.921581,
      '14110',
      '',
      '',
      1,
      '',
      '',
      '',
      3,
      '23432',
      '',
      '',
      1,
      0.077091,
      0.671051,
      NULL,
      0.650742,
      3,
      NULL,
      2,
      0.356895);
commit;
end;
/


