set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023505';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-2-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '301',
      '42204343',
      46,
      63,
      '1341014',
      145,
      NULL,
      1.070220,
      1,
      '211120',
      0,
      ' 7-17-1974',
      33.135992,
      34,
      1.045043,
      NULL,
      1.882926,
      0,
      3.726330,
      1.764026,
      1.306655,
      0.585770,
      0.304978,
      0,
      1.458569,
      1.450808,
      1,
      0.301781,
      1.286628,
      1.496235,
      0,
      NULL,
      1.745670,
      1.842389,
      1,
      NULL,
      0,
      0.799355,
      5.249315,
      1,
      0.036344,
      0.531892,
      NULL,
      1.357338,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1.186549,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.177517,
      1.375606,
      0,
      1,
      0,
      1,
      0.730387,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      5,
      NULL,
      2,
      0.778557,
      1.440669,
      0.458894,
      0.522810,
      NULL,
      1.516979,
      0,
      1.402640,
      NULL,
      1.366819,
      0,
      1,
      1.241221,
      0,
      NULL,
      0,
      6.460322,
      0.916680,
      0.577852,
      NULL,
      0.173736,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.317457,
      0,
      4.889284,
      0.142111,
      1.756242,
      3,
      2,
      2.780577,
      NULL,
      NULL,
      0.076444,
      5,
      7,
      4,
      0,
      3.011479,
      0.436239,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      1,
      1.459633,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.568812,
      NULL,
      9.468302,
      3,
      0.358767,
      0.048551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.938964,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1.111203,
      NULL,
      NULL,
      NULL,
      0.362589,
      7.357733,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2,
      NULL,
      1.954581,
      3,
      1,
      3.492268,
      0.701673,
      NULL,
      NULL,
      0.713095,
      1,
      0.665804,
      0,
      0,
      1,
      0.435527,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.465422,
      NULL,
      '',
      NULL,
      0.302053,
      '',
      '',
      '',
      0.562858,
      '02124',
      NULL,
      NULL,
      5,
      1,
      0.139712,
      0,
      3,
      1.429536,
      2.002083,
      1.380933,
      NULL);
commit;
end;
/


