set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8917132';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-7-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '03200213',
      0.421217,
      26.570713,
      '3424234',
      196,
      NULL,
      1,
      0,
      '131402',
      3,
      '10- 4-1988',
      NULL,
      NULL,
      0,
      NULL,
      1.240791,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      3.626052,
      0,
      0.130033,
      NULL,
      NULL,
      NULL,
      2.787697,
      0.968265,
      1.385710,
      1,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0,
      1.235368,
      1.807540,
      NULL,
      NULL,
      0.838921,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.848108,
      1.785551,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.252094,
      NULL,
      0.384989,
      1.457030,
      1,
      0.630974,
      1,
      0.043075,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.522806,
      0.503377,
      1,
      0,
      0,
      0,
      NULL,
      0,
      1.921943,
      0,
      0,
      NULL,
      0.431866,
      1.258470,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.517754,
      NULL,
      NULL,
      1.379943,
      0,
      7,
      0.980713,
      0,
      11.948809,
      7.691289,
      6.856327,
      8.322395,
      0.201507,
      4.902494,
      2,
      0.579894,
      NULL,
      1.591252,
      8,
      0.824060,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.548512,
      1,
      0,
      0.277362,
      0.789987,
      0,
      0.862775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.708724,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.442056,
      0.534959,
      NULL,
      0.804521,
      3.016726,
      0.639535,
      0.822959,
      NULL,
      5.922465,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.508501,
      1,
      1.775329,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.471339,
      1,
      2.849551,
      1.596317,
      1,
      0,
      2,
      1.352167,
      0.817019,
      NULL,
      1,
      0,
      1.024512,
      1.403936,
      0.235524,
      1.460945,
      NULL,
      NULL,
      0.263866,
      1.895167,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.846933,
      '41330',
      '',
      NULL,
      1.374122,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      0,
      1,
      NULL,
      1,
      0.527064,
      2,
      1.251409,
      0.059996);
commit;
end;
/


