set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8917132';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-9-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '10412424',
      59,
      27.416671,
      '3030240',
      182,
      1,
      2.846039,
      2,
      '121041',
      NULL,
      NULL,
      52,
      36.094703,
      NULL,
      NULL,
      1.227298,
      1.793223,
      NULL,
      NULL,
      NULL,
      0.494671,
      1,
      1,
      1.209691,
      1,
      NULL,
      0,
      1.881941,
      1.074749,
      0.992799,
      0,
      3.786936,
      1.640005,
      0,
      0.552259,
      0.741952,
      1,
      1.877952,
      NULL,
      NULL,
      1.089205,
      0.353893,
      0.910226,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.986199,
      1.446038,
      0.249725,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.638649,
      0,
      1.929765,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.923032,
      1,
      1.218658,
      NULL,
      1,
      0.691519,
      1,
      1.382442,
      0,
      1,
      0,
      1,
      1.434629,
      1.087356,
      NULL,
      0.722085,
      0.701083,
      0.547688,
      NULL,
      NULL,
      NULL,
      1.567208,
      NULL,
      NULL,
      1,
      1.814997,
      1.595753,
      1,
      1.715106,
      1.818872,
      NULL,
      1,
      1,
      0,
      0,
      1,
      0,
      NULL,
      3,
      NULL,
      5.509110,
      NULL,
      NULL,
      9,
      0.969340,
      1.356193,
      NULL,
      1.680470,
      2,
      0,
      NULL,
      9.385200,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.146089,
      1,
      0.037597,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.558144,
      NULL,
      NULL,
      NULL,
      NULL,
      1.715271,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.836103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.191420,
      NULL,
      4,
      NULL,
      0.445367,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.599550,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.088833,
      3,
      2.605053,
      NULL,
      0,
      0,
      1,
      1,
      0.936743,
      3.248154,
      3.815336,
      NULL,
      1,
      0,
      0.240922,
      1,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.862810,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.216004,
      NULL,
      '',
      NULL,
      0.499770,
      '',
      '',
      '',
      1.319797,
      NULL,
      NULL,
      '',
      2,
      2.452635,
      0.345486,
      4,
      1,
      1.625571,
      2.705390,
      1,
      NULL);
commit;
end;
/


