set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8917132';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-3-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '320',
      '03031111',
      9,
      NULL,
      NULL,
      75.576283,
      5,
      0,
      0,
      '321411',
      0,
      '11-25-1977',
      39,
      15,
      0,
      NULL,
      0,
      0,
      NULL,
      1.796042,
      NULL,
      1,
      NULL,
      3.218169,
      0.431694,
      NULL,
      4,
      0.429695,
      0.421159,
      1,
      1.938683,
      0,
      0,
      0,
      1.416800,
      1.278658,
      NULL,
      0.847305,
      7.092345,
      1,
      NULL,
      NULL,
      0,
      0.422935,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.939007,
      0,
      0,
      0.347395,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.788711,
      0,
      0.807503,
      1,
      NULL,
      1,
      0.916712,
      1.818042,
      1,
      1,
      NULL,
      0,
      1.578594,
      1.084417,
      1.225470,
      1,
      0.737046,
      1,
      NULL,
      NULL,
      0.015958,
      1.283641,
      1.151240,
      0.801446,
      1,
      1.983955,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.984388,
      0,
      NULL,
      0,
      NULL,
      3.546862,
      8,
      6,
      5,
      2,
      4,
      NULL,
      6,
      2.198488,
      NULL,
      2.765361,
      0.165013,
      1,
      1.287419,
      0.395303,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.119461,
      1,
      1,
      NULL,
      1.837106,
      0,
      1,
      1.687568,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.712226,
      NULL,
      8,
      3.023269,
      1.388259,
      NULL,
      0.232334,
      1,
      0,
      1,
      3,
      0.794053,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.927408,
      NULL,
      1,
      2,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.872512,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.427123,
      1,
      1.629752,
      0.696589,
      0.042325,
      NULL,
      3.817993,
      1.843467,
      0.966681,
      NULL,
      0,
      0,
      0,
      NULL,
      0.217840,
      1,
      0,
      1.272160,
      0,
      0.381848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '14040',
      '',
      '',
      1.339363,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      3.672708,
      3,
      1.491399,
      2.498853,
      NULL,
      4,
      3.065464,
      0,
      3);
commit;
end;
/


