set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8917132';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-3-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3424',
      '31440314',
      55,
      NULL,
      '4144201',
      261,
      NULL,
      1,
      1,
      '042400',
      1.275292,
      ' 9- 1-1985',
      NULL,
      16,
      1,
      NULL,
      NULL,
      0.370035,
      0,
      1.369108,
      0.163418,
      0,
      1.743347,
      0.875407,
      0.023193,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.558498,
      0,
      0,
      1.708630,
      1.411503,
      0,
      NULL,
      1.118294,
      2.373606,
      0,
      NULL,
      1,
      1.222945,
      1.169684,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.380327,
      0,
      1.014116,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.582759,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.647600,
      0,
      1.675355,
      NULL,
      1,
      0,
      0.850828,
      1.381748,
      0,
      1.084776,
      NULL,
      1,
      NULL,
      1.845354,
      1,
      NULL,
      1.107202,
      NULL,
      1.506730,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      1.878028,
      1,
      1,
      1,
      1,
      4.867772,
      5.806310,
      2,
      7,
      9,
      4,
      NULL,
      5.268101,
      1.938317,
      0.650534,
      0,
      2,
      1,
      0,
      9.089183,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.888676,
      1.057697,
      1,
      NULL,
      0.183784,
      0,
      0,
      1.378258,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.243463,
      NULL,
      NULL,
      NULL,
      NULL,
      1.374096,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.005426,
      1.956395,
      NULL,
      3,
      1.713545,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.507420,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.676103,
      1.611520,
      1,
      0,
      0,
      NULL,
      0.305080,
      1,
      2.558961,
      NULL,
      NULL,
      1.526283,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.302483,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '03413',
      '',
      '',
      0.276077,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      0.874762,
      2.978034,
      3.086848,
      3.547605,
      3,
      NULL,
      0,
      0,
      NULL);
commit;
end;
/


