set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8115606';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-3-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '203',
      '03222414',
      2,
      48,
      '0011442',
      11,
      3,
      NULL,
      0,
      '424343',
      4,
      ' 7-22-1993',
      19,
      99,
      0.576925,
      NULL,
      1.247490,
      NULL,
      1.143726,
      1,
      3.758755,
      1,
      3,
      2.979184,
      1,
      0.004332,
      9.129350,
      0,
      NULL,
      6,
      1.889501,
      1,
      3.347905,
      0.124730,
      0.068996,
      1.810945,
      0.363915,
      NULL,
      4.727974,
      1,
      2.504949,
      NULL,
      NULL,
      0.033958,
      NULL,
      NULL,
      1.738218,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.555277,
      1,
      1,
      2,
      NULL,
      NULL,
      1,
      2,
      3,
      1.984561,
      NULL,
      2.726786,
      1,
      3,
      NULL,
      3.791221,
      0,
      1,
      0.641670,
      4.129750,
      1,
      2,
      1.576847,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.161525,
      0,
      1,
      1.856155,
      1,
      0,
      NULL,
      NULL,
      0.730901,
      0.423825,
      0.490658,
      1.395463,
      1.851621,
      1.370731,
      0,
      NULL,
      1.686034,
      NULL,
      NULL,
      NULL,
      0.782729,
      NULL,
      1.253512,
      0.729823,
      1.987066,
      0,
      3.991592,
      0,
      9.246051,
      NULL,
      3.186036,
      NULL,
      NULL,
      NULL,
      NULL,
      1.854216,
      NULL,
      6,
      0,
      7.289450,
      9,
      8.628253,
      NULL,
      8,
      7.158276,
      0.190803,
      NULL,
      NULL,
      2,
      1,
      1,
      3,
      1.796344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      2,
      1,
      1.673659,
      1,
      1.610074,
      1.673007,
      3,
      1,
      NULL,
      NULL,
      0.398597,
      NULL,
      NULL,
      NULL,
      NULL,
      3.688163,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.917360,
      2,
      4.028865,
      1.477783,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.267427,
      5,
      0.176492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.506207,
      0,
      3.322603,
      2,
      2.419567,
      1,
      NULL,
      1,
      1,
      2,
      NULL,
      0,
      0.218500,
      1,
      1,
      0.861190,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.897596,
      NULL,
      1.629627,
      1.311831,
      0.893877,
      0,
      NULL,
      '22123',
      '',
      NULL,
      0.716190,
      '',
      '',
      '',
      1,
      '13022',
      '2233',
      '',
      4,
      5.936021,
      3,
      0.930699,
      NULL,
      3.437310,
      3,
      NULL,
      1);
commit;
end;
/


