set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8115606';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-10-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '333',
      '33102002',
      NULL,
      25.277974,
      '1440043',
      NULL,
      0,
      3,
      NULL,
      NULL,
      3.471710,
      ' 1-12-1999',
      20,
      178.326535,
      0,
      NULL,
      0,
      2.027036,
      NULL,
      0,
      2,
      1,
      3.189478,
      NULL,
      3,
      1.474859,
      2.826934,
      1,
      1.587922,
      5,
      0.012514,
      1,
      NULL,
      NULL,
      0.024668,
      1.088444,
      0.256462,
      0.144514,
      NULL,
      1,
      5,
      0.520579,
      1.755772,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.691216,
      NULL,
      NULL,
      0.857723,
      NULL,
      3.888802,
      0,
      3.409058,
      NULL,
      1.569300,
      1,
      0.359978,
      NULL,
      NULL,
      1,
      1.483686,
      1.052423,
      1,
      NULL,
      6,
      0,
      2,
      1,
      0.756338,
      NULL,
      NULL,
      0.451338,
      NULL,
      NULL,
      1.527068,
      0,
      1.793760,
      NULL,
      1.368152,
      0,
      0.698319,
      1,
      0.063300,
      0.759682,
      1.668299,
      1.254033,
      1,
      0,
      1.404053,
      0.488127,
      0,
      0,
      0.559981,
      NULL,
      0.466453,
      4.183855,
      1.713083,
      0.450726,
      NULL,
      NULL,
      1.777246,
      NULL,
      3,
      NULL,
      1,
      0,
      NULL,
      NULL,
      4,
      0,
      1,
      NULL,
      1.626599,
      2.855286,
      3.190674,
      5,
      4,
      3,
      11.529413,
      1.231756,
      1,
      1.023697,
      NULL,
      NULL,
      0,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.949093,
      1.639590,
      1,
      0,
      0.618690,
      1.504422,
      0,
      3.916726,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.925474,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.725631,
      7.977160,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.371861,
      1.817819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.158127,
      2,
      NULL,
      3.278006,
      0.245563,
      NULL,
      3.970163,
      1,
      0,
      1,
      1,
      0.307439,
      0,
      NULL,
      0.267321,
      1.976665,
      0.539220,
      1.780759,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.511143,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.309487,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.356900,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.487268,
      0.324706,
      0,
      NULL,
      1.376818,
      1.516190,
      1,
      0,
      1,
      '12431',
      NULL,
      '',
      0,
      NULL,
      '',
      '',
      NULL,
      '24224',
      NULL,
      '',
      3,
      1.628101,
      2.579135,
      1.129974,
      2.705416,
      0,
      3.717347,
      1.735703,
      1.904154);
commit;
end;
/


