set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8115606';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-5-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '044',
      '34414023',
      NULL,
      58,
      '2022311',
      9.489161,
      0,
      2,
      0,
      '220010',
      NULL,
      ' 1- 0-1993',
      128,
      192.333253,
      0,
      NULL,
      3.412250,
      NULL,
      0.963532,
      0,
      2.756459,
      NULL,
      NULL,
      1,
      1,
      0.127469,
      6.910430,
      0,
      1,
      1.471851,
      0,
      0.600311,
      0.127083,
      1.946815,
      1,
      0.355634,
      0,
      0.772819,
      8,
      1,
      4.009771,
      0.010622,
      1.811132,
      0.532432,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1.005807,
      7,
      3.240530,
      0.149430,
      1.473393,
      NULL,
      0.373213,
      1.914567,
      0,
      1,
      1.994798,
      0,
      1.591958,
      2.593072,
      2.763179,
      NULL,
      1,
      NULL,
      1,
      0.441066,
      1.486889,
      7.707699,
      0,
      1,
      0.083663,
      1.388664,
      NULL,
      NULL,
      0.184775,
      NULL,
      NULL,
      1.888535,
      1,
      1,
      1,
      NULL,
      0,
      1.714598,
      0.098517,
      NULL,
      1.344173,
      1.416165,
      1.260234,
      NULL,
      0.826584,
      0.671498,
      0,
      0.802624,
      1.588209,
      1,
      NULL,
      1,
      3,
      1.887723,
      0,
      0,
      1,
      5.925052,
      NULL,
      4,
      1.294865,
      1,
      0.974610,
      6,
      1,
      4.067467,
      1.567004,
      4.411460,
      NULL,
      6,
      6.981974,
      6.131919,
      8.133376,
      NULL,
      3.124571,
      5.686191,
      1,
      0.593790,
      1,
      NULL,
      0.625365,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      1.329765,
      0.235700,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.691962,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.974141,
      0,
      NULL,
      3,
      0.560810,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.977294,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.849637,
      1.260894,
      0.474782,
      NULL,
      0.670065,
      2,
      3.528103,
      NULL,
      0,
      1.128433,
      1,
      0.757239,
      1.691632,
      0,
      0.124754,
      0.082961,
      0.952062,
      0.475273,
      0,
      1.767554,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.585997,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.686264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.695998,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.860902,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.362331,
      NULL,
      1.258677,
      1,
      0,
      1,
      0,
      NULL,
      '',
      '',
      0.025084,
      NULL,
      '',
      '',
      3.568053,
      '11041',
      '2311',
      '',
      NULL,
      1.210765,
      0.830340,
      3,
      NULL,
      NULL,
      NULL,
      0.447915,
      0);
commit;
end;
/


