set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8115606';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-10-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '440',
      '22333141',
      43,
      2,
      '2304111',
      NULL,
      5,
      1.150414,
      NULL,
      '113244',
      3.361827,
      ' 2- 9-1988',
      NULL,
      56.262898,
      1.720901,
      NULL,
      3,
      3.219664,
      0,
      0,
      2,
      1.490946,
      1.016277,
      1.529863,
      NULL,
      1.668531,
      1,
      1.586652,
      0.216225,
      8.651086,
      0.477529,
      NULL,
      3.149114,
      NULL,
      1.151785,
      1.867878,
      1.925202,
      1.927231,
      3.035189,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.570130,
      NULL,
      NULL,
      4,
      NULL,
      9,
      3,
      0.105184,
      1,
      2.329972,
      0,
      1.573512,
      0.597841,
      NULL,
      0,
      0,
      3.969069,
      0,
      2,
      2.433210,
      NULL,
      NULL,
      0,
      NULL,
      0.534409,
      NULL,
      0,
      0,
      2.227205,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.679381,
      1,
      NULL,
      4,
      4.153149,
      0,
      1.639153,
      1.821027,
      NULL,
      1,
      1.137232,
      1.875746,
      NULL,
      0.930719,
      NULL,
      0.349832,
      1,
      0,
      NULL,
      NULL,
      1.823265,
      NULL,
      7.614908,
      1.091275,
      NULL,
      1.238131,
      0.784306,
      NULL,
      4,
      1.789924,
      NULL,
      0,
      NULL,
      NULL,
      8.277015,
      0.183920,
      0,
      NULL,
      NULL,
      8,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      5.642433,
      0.452703,
      0.805195,
      NULL,
      1,
      6.919618,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.033515,
      1,
      1,
      0,
      1,
      0.629923,
      0,
      NULL,
      0,
      NULL,
      1.363763,
      NULL,
      NULL,
      0.998084,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1,
      2,
      1,
      NULL,
      9,
      9.160382,
      2.079357,
      1.108375,
      NULL,
      NULL,
      NULL,
      0,
      1.263919,
      5.902363,
      8.699300,
      6.011879,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.824114,
      1.042322,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.228028,
      3.692382,
      1.012849,
      2,
      0.120395,
      NULL,
      NULL,
      2.407435,
      1.548086,
      NULL,
      2.970853,
      NULL,
      1.875695,
      0.075751,
      NULL,
      1,
      0,
      1.962068,
      NULL,
      1.822646,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.293864,
      '01034',
      '',
      '',
      0,
      '',
      '',
      NULL,
      5,
      '33400',
      NULL,
      '',
      3,
      NULL,
      3,
      2,
      0,
      NULL,
      1.202420,
      0.253165,
      1.651021);
commit;
end;
/


