set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8115606';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-5-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '243',
      '31132441',
      47,
      65,
      NULL,
      48.015974,
      3,
      2.969212,
      2,
      '302400',
      1,
      ' 4-29-1985',
      18,
      66,
      1.723009,
      NULL,
      1.851158,
      0.146732,
      3.783773,
      1,
      0,
      0.495836,
      2,
      NULL,
      1,
      1,
      2,
      NULL,
      NULL,
      7,
      0.761828,
      0.349922,
      0,
      0,
      0.429789,
      NULL,
      1.899985,
      0,
      6.725326,
      0,
      NULL,
      4,
      2.852503,
      1,
      NULL,
      NULL,
      1.782390,
      NULL,
      NULL,
      NULL,
      1.588801,
      5.669979,
      3,
      0,
      1,
      NULL,
      NULL,
      2.138103,
      1.985541,
      NULL,
      0,
      0,
      3.850004,
      1.427388,
      3,
      NULL,
      3.819623,
      2.401499,
      0,
      0,
      0.062335,
      9.001823,
      0,
      2,
      0,
      1.203612,
      NULL,
      NULL,
      1.621685,
      NULL,
      NULL,
      0,
      1.080869,
      1,
      3,
      1.010223,
      1.301989,
      NULL,
      0,
      0,
      0.665699,
      0,
      0.418535,
      0.799419,
      1.121369,
      1,
      0.262750,
      0.492915,
      1,
      NULL,
      NULL,
      0.051670,
      0,
      3,
      0.762202,
      1.633518,
      0,
      6.580500,
      1,
      9.977975,
      5.350175,
      2,
      0,
      2.039978,
      0,
      NULL,
      0.971986,
      NULL,
      8.897686,
      5,
      6,
      11.002949,
      1,
      4,
      10.460246,
      11.054476,
      0,
      4,
      2,
      NULL,
      1,
      NULL,
      7,
      1.788953,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.678281,
      NULL,
      0,
      0.749323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.090081,
      NULL,
      2.323567,
      1.814921,
      1.287167,
      3.520405,
      5,
      NULL,
      0.369797,
      NULL,
      NULL,
      NULL,
      1.235788,
      NULL,
      2,
      0,
      4,
      0,
      0.053633,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.433547,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.451226,
      NULL,
      0.720187,
      1.018945,
      NULL,
      NULL,
      1,
      2,
      2,
      NULL,
      0.601306,
      NULL,
      1,
      NULL,
      1,
      1,
      0.707490,
      1.666513,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.141945,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.963024,
      '01420',
      NULL,
      '',
      0,
      NULL,
      NULL,
      '',
      1.538282,
      NULL,
      NULL,
      '3021',
      0,
      2.325660,
      2,
      3,
      0,
      1.003470,
      1,
      3.161656,
      NULL);
commit;
end;
/


