set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8115606';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-11-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '211',
      '40134102',
      20.454501,
      14.242194,
      '1201224',
      43,
      4,
      3.788553,
      3,
      '414013',
      NULL,
      '11-21-1987',
      34.504049,
      146,
      1.977101,
      NULL,
      0.352030,
      1.086539,
      2.811349,
      0.920415,
      0,
      NULL,
      1.507603,
      0.600730,
      NULL,
      1,
      0.805126,
      1,
      NULL,
      4,
      0,
      0.688188,
      2.392482,
      3.759030,
      3,
      1,
      0,
      1,
      0,
      0,
      0.140450,
      4.794671,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6.192217,
      0.185521,
      9,
      NULL,
      NULL,
      1.657782,
      3.503555,
      NULL,
      1.070190,
      0.010203,
      3,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.672659,
      1.100779,
      1.306883,
      NULL,
      1,
      2,
      5.294214,
      1.469749,
      NULL,
      NULL,
      0.753105,
      NULL,
      NULL,
      1.885666,
      1,
      1.840134,
      2,
      0.477511,
      NULL,
      0.742612,
      0,
      1,
      0.269389,
      0.618467,
      NULL,
      0.287080,
      1.977831,
      0,
      1.500845,
      1,
      0,
      1,
      NULL,
      NULL,
      0.598291,
      5,
      1,
      0,
      1.685614,
      0,
      0,
      8,
      2.225501,
      3,
      NULL,
      0.772257,
      3,
      0.233706,
      1.719936,
      1.284303,
      1,
      8,
      7.165761,
      3.658464,
      9,
      0,
      11.175894,
      NULL,
      0,
      0.493241,
      1,
      0,
      NULL,
      0.696153,
      1.344056,
      0.904015,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.231509,
      1,
      NULL,
      NULL,
      1.669220,
      1,
      0,
      1.105286,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.249401,
      NULL,
      NULL,
      NULL,
      NULL,
      1.973461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.419793,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.277717,
      1,
      1.681421,
      1.830930,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.806153,
      3.938128,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      3.454637,
      1.159593,
      3.660430,
      1.005387,
      NULL,
      NULL,
      NULL,
      0,
      1.021687,
      0,
      0,
      0.233913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.532405,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.550965,
      NULL,
      1.735017,
      NULL,
      NULL,
      0.858951,
      1,
      NULL,
      3,
      NULL,
      '',
      '',
      0,
      '',
      '',
      NULL,
      4,
      '32102',
      '0001',
      '3231',
      3.750942,
      1,
      NULL,
      1.185542,
      1.482265,
      1.738951,
      NULL,
      2.356937,
      0);
commit;
end;
/


