set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8115606';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-6-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      53.325363,
      73,
      '3210120',
      69.081594,
      6,
      0,
      2,
      '314320',
      1.076722,
      ' 0- 1-1982',
      24,
      147.678653,
      NULL,
      NULL,
      3,
      1,
      3.488960,
      1.795112,
      NULL,
      1.056471,
      0.060519,
      0.444308,
      0.922639,
      1,
      1.866371,
      1,
      0.893869,
      4,
      NULL,
      1.946810,
      6.019867,
      7,
      2,
      0,
      0.139901,
      1.284965,
      4.900819,
      0,
      NULL,
      1,
      1,
      0.434073,
      NULL,
      NULL,
      1.067993,
      NULL,
      NULL,
      3.750568,
      1.013785,
      NULL,
      3,
      1.784970,
      1.513954,
      0.561063,
      0.044787,
      3,
      0.387020,
      NULL,
      0,
      NULL,
      NULL,
      2,
      2.602317,
      NULL,
      1.807220,
      3,
      1,
      NULL,
      1.367546,
      NULL,
      NULL,
      NULL,
      1.467685,
      1.061402,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      5,
      4.049056,
      6,
      NULL,
      0.480258,
      0.895668,
      1,
      1.189120,
      0.164628,
      NULL,
      0.956372,
      NULL,
      0,
      1,
      1,
      0.470199,
      NULL,
      NULL,
      0.559732,
      0.848992,
      4,
      0.202236,
      0.568040,
      NULL,
      5,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      6,
      0,
      3.183543,
      NULL,
      2,
      NULL,
      NULL,
      10.921335,
      7,
      3.424793,
      NULL,
      3,
      11,
      NULL,
      9,
      2,
      0,
      0.886949,
      0.709766,
      5.033172,
      1.581619,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.393103,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.522283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.763269,
      4,
      NULL,
      1.506623,
      0,
      1.901813,
      NULL,
      NULL,
      NULL,
      0.833368,
      1,
      1.826293,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.916651,
      2,
      3.833035,
      0.909562,
      0,
      1.732137,
      0.811289,
      0.815913,
      1.226350,
      2,
      1,
      NULL,
      0.545591,
      1.117620,
      NULL,
      1,
      1.510117,
      0.962951,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.689498,
      1.370714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.022429,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.180262,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.482957,
      NULL,
      NULL,
      1.952354,
      NULL,
      1,
      2,
      0.111117,
      '44432',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.231903,
      '00003',
      '3301',
      '0103',
      0.718926,
      1,
      0.404481,
      NULL,
      1,
      0,
      5.525454,
      NULL,
      3);
commit;
end;
/


