set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8115606';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-11-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3224',
      '30010232',
      63.588584,
      18,
      '3134420',
      NULL,
      1,
      0.720704,
      NULL,
      '341334',
      NULL,
      ' 9- 6-1984',
      118.771928,
      157,
      0.516337,
      NULL,
      2,
      1,
      2,
      NULL,
      0,
      0,
      1,
      1,
      1,
      0,
      5,
      0.838427,
      NULL,
      4,
      1.559310,
      1,
      4,
      NULL,
      2.045425,
      5,
      1.378137,
      1.382069,
      NULL,
      0,
      1.517869,
      5.496454,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.625719,
      1,
      7,
      NULL,
      1.418881,
      0.978920,
      3.426065,
      0,
      NULL,
      0,
      3.337820,
      1.332601,
      1.521852,
      NULL,
      1,
      0.091620,
      3,
      1,
      2.902221,
      0,
      0.306364,
      1.890309,
      4,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.825381,
      1,
      NULL,
      7,
      6,
      1.524101,
      1.402631,
      1,
      NULL,
      0.966226,
      0.972791,
      NULL,
      0.267473,
      0.950062,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.599286,
      NULL,
      4,
      0.832059,
      NULL,
      NULL,
      5,
      1.063154,
      4,
      4.222317,
      0,
      1.951922,
      3,
      0.402953,
      0.362942,
      0,
      NULL,
      11,
      3,
      NULL,
      5,
      NULL,
      3,
      NULL,
      1,
      3.571156,
      NULL,
      4.594049,
      3,
      1.930372,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2,
      0.830785,
      NULL,
      1.288846,
      1.125149,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.345727,
      NULL,
      NULL,
      NULL,
      NULL,
      7.427004,
      NULL,
      0,
      0.786074,
      NULL,
      6,
      1,
      NULL,
      1.155790,
      NULL,
      NULL,
      NULL,
      0,
      0.456030,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.687444,
      1.990255,
      1.489840,
      NULL,
      0,
      1.001608,
      0.391125,
      3,
      3.687247,
      NULL,
      NULL,
      1.988217,
      NULL,
      1.221777,
      1.098003,
      0,
      1.944954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.407169,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.888622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.618943,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.007674,
      NULL,
      0.570955,
      0,
      NULL,
      NULL,
      1.391137,
      '13443',
      '',
      '',
      NULL,
      '',
      '',
      '',
      6.328501,
      '41123',
      '4034',
      '3231',
      4,
      3.754417,
      3,
      1.925851,
      1.948100,
      0.510786,
      3,
      2.263769,
      NULL);
commit;
end;
/


