set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8115606';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-4-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4130',
      NULL,
      NULL,
      14,
      '4030223',
      66.603808,
      NULL,
      0.935502,
      NULL,
      '402213',
      3,
      NULL,
      28,
      9,
      NULL,
      NULL,
      0,
      0,
      2,
      0.448773,
      0,
      2,
      NULL,
      3,
      1,
      NULL,
      9.549570,
      1.667616,
      1,
      4,
      0,
      1.093758,
      NULL,
      NULL,
      1,
      1,
      1.550268,
      0,
      NULL,
      1,
      3,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.269119,
      10,
      NULL,
      3,
      1,
      0.795754,
      3.777999,
      0,
      0.169720,
      0.638605,
      3,
      NULL,
      1,
      1.470131,
      1.208178,
      2.020544,
      1,
      0,
      1.652029,
      0,
      0.354368,
      0,
      10,
      0,
      1,
      3,
      0,
      NULL,
      NULL,
      1.526576,
      NULL,
      NULL,
      0,
      0.187249,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1.622978,
      1.666667,
      1.069284,
      NULL,
      0.301656,
      1.014427,
      1.939379,
      NULL,
      1,
      NULL,
      0.181965,
      1,
      0.229145,
      3,
      3,
      NULL,
      5,
      NULL,
      7.822407,
      NULL,
      4.854038,
      4.624680,
      5.687409,
      2,
      6,
      0.693213,
      NULL,
      8.514441,
      5,
      9,
      6,
      0,
      3.330123,
      4,
      5,
      1.229686,
      0.305745,
      0.560852,
      1.795767,
      NULL,
      NULL,
      1,
      0.309356,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.902217,
      1,
      0,
      0,
      0,
      1.216591,
      0.725668,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.161745,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1.761702,
      1.682433,
      1.426809,
      NULL,
      NULL,
      0.470092,
      0,
      NULL,
      NULL,
      NULL,
      0.582439,
      NULL,
      NULL,
      7,
      1,
      2,
      1.832989,
      NULL,
      NULL,
      NULL,
      0.767259,
      4,
      1.106549,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      3.037244,
      0.913277,
      1.744785,
      0,
      2,
      NULL,
      NULL,
      3,
      1,
      1,
      1.173362,
      NULL,
      NULL,
      NULL,
      0,
      0.987700,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.431429,
      0.245813,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.252613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.187215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.460019,
      NULL,
      NULL,
      NULL,
      NULL,
      0.759761,
      NULL,
      NULL,
      NULL,
      NULL,
      1.495798,
      0,
      0.270255,
      NULL,
      0,
      0.961915,
      1.198883,
      NULL,
      1,
      '31412',
      '',
      '',
      1.388953,
      '',
      '',
      '',
      4,
      '40001',
      '4241',
      '3204',
      5.515406,
      1.049045,
      NULL,
      3,
      1.355422,
      0,
      NULL,
      1.735381,
      2.222726);
commit;
end;
/


